const orderHref = window.__order_href;
const orderOriginParam = window.__origin_param;

(function (exp) {
  const countryCode = "AE";
  const lang = "en-AE";
  const locale = lang;

  const sizes = {
    enabled: true,
    selectText: "Sizes: ",
    arr: [
      "EU 36",
      "EU 37",
      "EU 37.5",
      "EU 38",
      "EU 38.5",
      "EU 39",
      "EU 39.5",
      "EU 40",
      "EU 40.5",
      "EU 41",
      "EU 41.5",
      "EU 42",
      "EU 42.5",
      "EU 43",
      "EU 43.5",
      "EU 44",
      "EU 44.5",
      "EU 45",
      "EU 45.5",
      "EU 46",
      "EU 46.5",
      "EU 47",
      "EU 47.5",
      "EU 48",
      "EU 49",
      "EU 50",
      "EU 51",
      "EU 52",
    ],
  };

  const mainProduct = {
    header: "Limited offer",
    name:   "Adidas Gazelle",
    oldPrice: "345,00 AED",
    newPrice: "8,00 AED",
    selectText: "Colore: ",
    text: `
    ¡Congratulazioni!
    <br><br>
    Hai partecipato alla promozione di Decathlon e hai la possibilità di acquistare le scarpe Adidas Gazelle per soli <b>8,00 AED</b>!
    <br><br>
    Affrettati a ottenere le Adidas Gazelle mentre la promozione è ancora valida! Le quantità sono limitate a 100 set!
    <br><br>
  `,
  };


  const notifications = [
    {
      user: "Amir S*****",
      location: "Milana, Italia",
      action: "I just bought some sneakers for 8,00 AED!",
      timeago: "15 seconds ago",
    },
    {
      user: "Omar B******",
      location: "Napoli, Italia",
      action: "I just bought some sneakers for 8,00 AED!",
      timeago: "25 seconds ago",
    },
  ];

  const reviewsArr = [
    {
      name: "Rayan",
      time: "1 day ago",
      header: "Perfect comfort and style!",
      product: "HQ6448",
      review:
          "I am simply in love with my new Adidas Gazelle sneakers! They are very comfortable and stylish. I purchased them for the summer and I am very satisfied. The delivery was fast and the item arrived in perfect condition.",
    },
    {
      name: "Zaid",
      time: "2 days ago",
      header: "A dream come true!",
      product: "MR530EMB",
      review:
          "Adidas Gazelle shoes are a dream come true! The quality is amazing and they fit my feet perfectly. The combination of style and comfort is perfect. They are ideal for everyday wear or even for a more casual look. I highly recommend them!",
    },
    {
      name: "Karim",
      time: "3 days ago",
      header: "Ideal support for athletes!",
      product: "MR530EMB",
      review:
          "I bought Adidas Gazelle sneakers to wear to the gym and they are great! Besides being lightweight, they provide ideal support for tired feet. The sole is non-slip, ideal for preventing slipping. I am very satisfied with my purchase!",
    },
    {
      name: "Zain",
      time: "5 days ago",
      header: "An irresistible touch of style!",
      product: "HQ6448",
      review:
          "These Adidas Gazelle sneakers are definitely a must-have for fashionistas. They will add a touch of style to any everyday look. In addition, the quality is excellent and durable. I am completely satisfied with my choice!",
    },
    {
      name: "Jad",
      time: "8 days ago",
      header: "Luxury for the feet!",
      product: "MR530EMB",
      review:
          "I recommend it to anyone who wants something special in their shoe collection!",
    },
  ];

  const reviews = {
    reviews: reviewsArr,
    rr:      "REVIEWS AND RATINGS",
    percent: "99%",
    rec:      "Recommend this product",
  };

  const questions = {
    _of: "Question {1}/{2}:",
    arr: [
      {
        q: "Have you ever purchased products from Decathlon?",
        a: ["YES", "This is my first purchase"],
      },
      {
        q: "Who are these shoes for?",
        a: [
          "For me",
          "For my friend",
          "For a member of my family",
        ],
      },
      {
        q: "Would you recommend our products to your friends?",
        a: ["YES", "NO"],
      },
    ],
  };

  const check = {
    title: "Your response will be checked...",
    arr: [
      "You answered question 3/3.",
      "Your IP address does not allow us to draw conclusions about previous requests.",
      "Your response has been checked.",
    ],
  };

  const modals = {
    welcome: {
      texts: {
        header: "Congratulations, you have successfully confirmed your participation in the promotion.",
        button: "OK",
        text: `
      <center>
        Today, {date}, is your chance to buy a pair of Adidas Gazelle shoes.
        <br><br>
        You just need to choose the correct gift box.
        <br><br>
        You have 3 tries, good luck!
      </center>
    `,
      },
    },
    first: {
      texts: {
        header: "Oh no...",
        button: "OK",
        text: `
      <center>
      Sorry, this gift box is empty! You have 2 more tries, good luck!
      </center>
    `,
      },
    },
    win: {
      texts: {
        header: "Congratulations, you won!",
        button: "OK",
        text: `
      <center>
        <p style="color: #000">
         You have won Adidas Gazelle sneakers.
        </p>
        <br>
          1) Click "OK" to access the shipping page.
          <br><br>
          2) Complete the form and pay to receive your shoes.
          <br><br>
          3) Your order will be delivered in 5-6 days.
      </center>
    `,
      },
    },
  };
  const cartSteps = {
    personal: {
      title: "Personal information",
      fields: {
        name: {
          field: "Name",
        },
        family: {
          field: "Last name",
        },
        phone: {
          field: "Phone number",
        },
        email: {
          field: "E-Mail",
        },
      },
    },
    delivery: {
      title: "Delivery",
      fields: {
        city: {
          field: "City",
        },
        address: {
          field: "Delivery address",
        },
        zip: {
          field: "ZIP Code",
        },
      },
    },
    payment: {
      title: "Payment method",
      creditCard: "Online payment by credit card",
    },
  };

  const cart = {
    steps: cartSteps,
    main: {
      title: "Order Summary.",
      oldPrice: "345,00 AED",
      newPrice: "8,00 AED",
      size: "Measure",
      subTotal: {
        title: "Order cost",
        amount: "8,00 AED",
      },
      delivery: {
        title: "Delivery",
        amount: "0.00 AED",
      },
      total: {
        title: "Total",
        amount: "8,00 AED",
      },
      checkoutButton: "Pay for your order",
    },
  };


  const productDesc = `

  
  `;

  const products = [
    {
      id: "MR530EMB",
      name: "Collegiate Green / Cloud White / Gum",
      miniImg: "./assets/grw_1.jpg",
      images: [
        "./assets/grw_1.jpg",
        "./assets/grw_2.jpg",
        "./assets/grw_3.jpg",
        "./assets/grw_4.jpg",
        // "./assets/grw_5.jpg",
      ],
    },
    {
      id: "MR530SG",
      name: "Arctic Fusion / Off White / Cream White",
      miniImg: "./assets/BL_1.jpg",
      images: [
        "./assets/gaselle_blue_gif3.gif",
        "./assets/BL_1.jpg",
        "./assets/BL_2.jpg",
        "./assets/BL_3.jpg",
        "./assets/BL_4.jpg",
        "./assets/BL_6.jpg",
        "./assets/BL_7.jpg",
      ],
    },
    {
      id: "MR530SMT",
      name: "Power Red / White / Gold Metallic",
      miniImg: "./assets/RW_1.jpg",
      images: [
        "./assets/RW_1.jpg",
        "./assets/RW_2.jpg",
        "./assets/RW_3.jpg",
        "./assets/RW_4.jpg",
        "./assets/RW_5.jpg",
        "./assets/RW_6.jpg",
      ],
    },

    {
      id: "MR530SMK",
      name: "Cloud White / Cloud White / Gold Metallic",
      miniImg: "./assets/W_1.jpg",
      images: [
        "./assets/W_1.jpg",
        "./assets/W_2.jpg",
        "./assets/W_3.jpg",
        "./assets/W_4.jpg",
        "./assets/W_5.jpg",
        "./assets/W_6.jpg",
      ],
    },
    {
      id: "MR530EMA",
      name: "Core Black / Core Black / Core Black",
      miniImg: "./assets/BLC_1.jpg",
      images: [
        "./assets/BLC_1.jpg",
        "./assets/BLC_2.jpg",
        "./assets/BLC_3.jpg",
        "./assets/BLC_4.jpg",
        "./assets/BLC_5.jpg",
        "./assets/BLC_6.jpg",
      ],
    },
    {
      id: "MR530EMC",
      name: "Collegiate Green / Hazy Sky / Victory Gold",
      miniImg: "./assets/grb_1.jpg",
      images: [
        "./assets/grb_1.jpg",
        "./assets/grb_2.jpeg",
        "./assets/grb_3.jpeg",
        "./assets/grb_4.jpeg",
        "./assets/grb_5.jpeg",
      ],
    },
    {
      id: "MR530EMD",
      name: "Easy Orange / Clear Mint / Gum",
      miniImg: "./assets/or_1.jpg",
      images: [
        "./assets/or_1.jpg",
        "./assets/or_2.jpeg",
        "./assets/or_3.jpeg",
        "./assets/or_4.jpeg",
        "./assets/or_5.jpeg",
      ],
    },
    {
      id: "MR530EME",
      name: "Semi Court Green / Almost Yellow / Gum",
      miniImg: "./assets/lgr_1.jpg",
      images: [
        "./assets/lgr_1.jpg",
        "./assets/lgr_3.jpeg",
        "./assets/lgr_4.jpeg",
        "./assets/lgr_5.jpeg",
      ],
    },
    {
      id: "MR530EMF",
      name: "Legend Ink / Wonder Beige / Gum",
      miniImg: "./assets/lbl_1.jpg",
      images: [
        "./assets/lbl_1.jpg",
        "./assets/lbl_2.jpeg",
        "./assets/lbl_3.jpeg",
        "./assets/lbl_4.jpeg",
        "./assets/lbl_5.jpeg",
      ],
    },
    {
      id: "MR530EMH",
      name: "Cream White / Collegiate Green / Gum",
      miniImg: "./assets/wh_1.jpg",
      images: [
        "./assets/wh_1.jpg",
        "./assets/wh_2.jpeg",
        "./assets/wh_3.jpeg",
        "./assets/wh_4.jpeg",
        "./assets/wh_5.jpeg",
      ],
    },
  ];

  const footer = {
    cr: "© 2024 Decathlon. All rights reserved.",
  };

  const pathImgBox = {
    lid: "./assets/box-lid.png",
    lidIOs: "./assets/box-lid-ios.png",
    inner: "./assets/box-inner.png",
    innerGift: "./assets/box-inner-gift.png",
    box: "./assets/box.png",
    boxModal: "./assets/box-modal.png",
  };

  exp.__config = {
    pathImgBox,
    countryCode,
    lang,
    locale,
    mainProduct,
    footer,
    check,
    questions,
    modals,
    cart,
    reviews,
    products,
    sizes,
    notifications,
  };
})(window);

window.addEventListener("load", () => {
  for (let path of Object.values(window.__config.pathImgBox)) {
    let link = document.createElement("link");
    link.setAttribute("as", "image");
    link.setAttribute("href", path);
    link.rel = "preload";
    document.head.appendChild(link);
  }
});

const lsSelectProduct = (val) =>
  localStorage.setItem("__selected_product", val);
const lsGetSelectedProduct = () => {
  const products = window.__config.products;
  let ind = localStorage.getItem("__selected_product");

  if (ind == null) {
    ind = products[0].id;
    lsSelectProduct(ind);
  }

  return products.find((pr) => pr.id === ind);
};
const lsGetSelectedProductInd = () => {
  return lsGetSelectedProduct().id;
};

const lsSelectSize = (val) => localStorage.setItem("__selected_size", val);
const lsGetSelectedSizeInd = () => {
  const ind = localStorage.getItem("__selected_size");
  let v = parseInt(ind);

  if (isNaN(v)) {
    v = 0;
    lsSelectSize(v);
  }

  return v;
};
const lsGetSelectedSize = () => {
  const sizes = window.__config.sizes;

  return sizes.arr?.[lsGetSelectedSizeInd()];
};

const lsGetProductImages = () => {
  return lsGetSelectedProduct()?.images ?? [];
};

const lsSetStep = (val) => localStorage.setItem("__step", val);
const lsGetStep = () => {
  const step = localStorage.getItem("__step", val);

  console.log(step);

  if (step != null) return step;

  lsSetStep("main");
  return "main";
};

const getProductById = (id) => {
  const products = window.__config.products;

  return products.find((pr) => pr.id === id);
};

const enableLoader = () => {
  const loader = document.querySelector(".loader");
  loader.setAttribute("style", "display: flex");
};
const disableLoader = () => {
  const loader = document.querySelector(".loader");
  loader.setAttribute("style", "display: none");
};

const openMain = () => {
  document.querySelector("#main").setAttribute("style", "display: block");
};
const closeMain = () => {
  document.querySelector("#main").setAttribute("style", "display: none");
};

const openGame = () => {
  document.querySelector("#game").setAttribute("style", "display: block");
};
const closeGame = () => {
  document.querySelector("#game").setAttribute("style", "display: none");
};

const openCheckout = () => {
  document.querySelector("#checkout").setAttribute("style", "display: block");
};
const closeCheckout = () => {
  document.querySelector("#checkout").setAttribute("style", "display: none");
};
