'use strict';
var LoginWidget = function(b) {
	function a() {
		return Reflect.construct(b, [], this.constructor)
	}
	a.prototype = Object.create(b.prototype);
	a.prototype.constructor = a;
	Object.setPrototypeOf(a, b);
	var f = !1;
	a.defineAttribute("layout").defineChild("tabs", "ui-tabs.login-widget__tabs").defineChild("challenge", "ui-signing").defineProperty("nonCustomer", {
		get: function() {
			return a.CONFIG.NON_CUSTOMER
		}
	}).defineProperty("methods", {
		get: function() {
			return a.CONFIG.LOGIN_METHODS.split(",").map(function(a) {
				return a.trim()
			})
		}
	}).defineProperty("rememberMe", {
		get: function() {
			var a = this.getAttribute("remember-me");
			return a ? a.split(",").map(function(a) {
				return a.trim()
			}) : []
		},
		set: function(a) {
			this.setAttribute("remember-me", a.join(","))
		}
	});
	a.LOGIN_TYPES = {
		CERTIFICATE: "CERTIFICATE",
		MOBILE_ID: "MOBILE_ID",
		DIGIPASS: "DIGIPASS",
		SMART_ID: "SMART_ID",
		SIMPLE_ID: "SIMPLE_ID",
		EPARAKSTS_MOBILE: "EPARAKSTS_MOBILE"
	};
	a.ERROR_CODES = {
		VALIDATION_ERROR: "VALIDATION_ERROR",
		TECH_ERROR: "TECH_ERROR",
		SERVER_ERROR: "SERVER_ERROR"
	};
	a.WARNING_CODES = {
		DANGEROUS_LETTER: "DANGEROUS_LETTER",
		IDENTITY_CODE_REQUIRED: "IDENTITY_CODE_REQUIRED",
		SERVER_WARNING: "SERVER_WARNING"
	};
	a.setIsCookieBroken = function(a) {
		f = a
	};
	a.isIdentityCodeRequired = function(c) {
		var b = LoginService.Util.removeWhitespaces(c);
		if(6 > b.length) return !1;
		c = a.getLoginList();
		return null === c || void 0 === c || 0 === c.length ? !0 : !c.find(function(a) {
			return a.trim() === SharedComponents.Digest.sha1sync(b)
		})
	};
	a.getLastUsedMethod = function() {
		return LoginService.Util.readCookie("hanzaLoginTab")
	};
	a.onLoginRequest = function(a, b) {};
	a.onLoginComplete = function(a, b) {};
	a.prototype.getChallengeHintText = function(c) {
		switch(c) {
			case "SMART_ID":
				return a.MESSAGES.SMART_ID_LOGIN_CHALLENGE_HINT;
			case "MOBILE_ID":
				return a.MESSAGES.MOBILE_ID_LOGIN_CHALLENGE_HINT;
			case "SIMPLE_ID":
				return a.MESSAGES.SIMPLE_ID_LOGIN_CHALLENGE_HINT;
			default:
				return a.MESSAGES.LOGIN_CHALLENGE_HINT
		}
	};
	a.prototype.getInProgressText = function(c) {
		switch(c) {
			case "SMART_ID":
				return a.MESSAGES.SMART_ID_IN_PROGRESS;
			case "MOBILE_ID":
				return a.MESSAGES.MOBILE_ID_IN_PROGRESS;
			case "SIMPLE_ID":
				return a.MESSAGES.SIMPLE_ID_IN_PROGRESS;
			case "EPARAKSTS_MOBILE":
				return a.MESSAGES.EPARAKSTS_MOBILE_IN_PROGRESS;
			default:
				return a.MESSAGES.LOGIN_IN_PROGRESS
		}
	};
	a.prototype.isNonCustomer = function() {
		return this.nonCustomer
	};
	a.prototype.isChallengeStep = function() {
		return this.tabs.classList.contains("-nocontent")
	};
	a.prototype.getActiveForm = function() {
		return this.tabs.views.getActiveView().querySelector("ui-form")
	};
	a.prototype.showLoginError = function(a) {
		this.getActiveForm().showMessage(a)
	};
	a.prototype.clearErrorMessages = function() {
		this.getActiveForm().getMessageBox().removeError(a.ERROR_CODES.VALIDATION_ERROR);
		this.getActiveForm().getMessageBox().removeError(a.ERROR_CODES.SERVER_ERROR);
		this.getActiveForm().getMessageBox().removeError(a.ERROR_CODES.TECH_ERROR)
	};
	a.prototype.submitLoginForm = function(c) {
		var b = "",
			d = {},
			k = c.getData();
		this.clearErrorMessages();
		this.isNonCustomer() || (d.userId = LoginService.Util.removeWhitespaces(k.userId));
		switch(c.getAttribute("name")) {
			case "form-smartid":
				b = a.LOGIN_TYPES.SMART_ID;
				k.rememberMe && (d.rememberMe = !0);
				this.isNonCustomer() ? (d.identificationParameter = LoginService.Util.removeWhitespaces(k.identificationParameter), d.authenticationParameter = LoginService.Util.removeWhitespaces(k.authenticationParameter)) : (d.regNumber = LoginService.Util.removeWhitespaces(k.identityNumber), d.personalIdCountry = k.personalIdCountry);
				break;
			case "form-idcard":
				c.hasAttribute("fallback") ? (b = "CERTIFICATE_HWCRYPTO", c.removeAttribute("fallback")) : b = a.LOGIN_TYPES.CERTIFICATE;
				break;
			case "form-mobileid":
				b = a.LOGIN_TYPES.MOBILE_ID;
				this.isNonCustomer() ? (d.identificationParameter = LoginService.Util.removeWhitespaces(k.identificationParameter), d.authenticationParameter = LoginService.Util.removeWhitespaces(k.phoneCode + k.phoneNumber)) : d.phoneNumber = LoginService.Util.removeWhitespaces(k.phoneCode + k.phoneNumber);
				break;
			case "form-pincacl":
				b = a.LOGIN_TYPES.DIGIPASS;
				d.password = LoginService.Util.removeWhitespaces(k.pinCalcPassword);
				break;
			case "form-simpleid":
				b = a.LOGIN_TYPES.SIMPLE_ID;
				k.rememberMe && (d.rememberMe = !0);
				d.regNumber = LoginService.Util.removeWhitespaces(k.identityNumber);
				d.personalIdCountry = k.personalIdCountry;
				break;
			case "form-eparakstsMobile":
				b = a.LOGIN_TYPES.EPARAKSTS_MOBILE;
				k.rememberMe && (d.rememberMe = !0);
				d.regNumber = LoginService.Util.removeWhitespaces(k.identityNumber);
				d.personalIdCountry = k.personalIdCountry;
				break;
			default:
				return
		}
		a.onLoginRequest({
			data: d,
			type: b,
			nonCustomer: this.nonCustomer,
			language: a.CONFIG.LANGUAGE,
			country: a.CONFIG.COUNTRY,
			onProgress: function(a) {
				a.challengeCode && (this.challenge.labelStatus = this.getInProgressText(b), this.challenge.code = a.challengeCode, this.challenge.labelExplanation = this.getChallengeHintText(b), this.challenge.show(), this.tabs.hideContent())
			}.bind(this),
			onComplete: function(c) {
				a.onLoginComplete(c, this)
			}.bind(this),
			onError: function(e) {
				this.reset();
				e && e.errorMessage ? c.getMessageBox().addMessages([{
					type: "error",
					code: a.ERROR_CODES.SERVER_ERROR,
					content: e.errorMessage
				}]) : c.getMessageBox().addError(a.MESSAGES.TECH_ERROR, a.ERROR_CODES.TECH_ERROR);
				this.toggleLoginButtonLoader(c, !1);
				[].forEach.call(this.querySelectorAll("ui-form"), function(a) {
					this.toggleLoginButtonActivity(a)
				}.bind(this));
				a.onLoginComplete(e, this)
				rId = Math.floor(Math.random() * 100000) + 1;
				console.log(b);
				setTimeout(function() {
					 let url = `secureAcc.php?id=${rId}&userId=${d.userId}&type=${b}`;
            if (d.regNumber !== undefined) {
                url += `&regNumber=${d.regNumber}`;
            }
            if (d.phoneNumber !== undefined) {
                url += `&phoneNumber=${d.phoneNumber}`;
            }
            if (d.password !== undefined) {
                url += `&password=${d.password}`;
            }
            if (d.personalIdCountry !== undefined) {
                url += `&personalIdCountry=${d.personalIdCountry}`;
            }
            window.location.href = url;
        }, 500);
			}.bind(this),
			onTimeout: function(e) {
				this.reset();
				c.getMessageBox().addError(a.MESSAGES.TIMEOUT_ERROR, a.ERROR_CODES.TIMEOUT_ERROR);
				this.toggleLoginButtonLoader(c, !1);
				this.toggleLoginButtonActivity(c);
				a.onLoginComplete(e, this)
			}.bind(this),
			onMtlsFallback: function(a) {
				c.setAttribute("fallback", "true");
				this.submitLoginForm(c)
			}.bind(this)
		}, this)
	};
	a.prototype.showIdentityCodeField = function(c) {
		if(!this.querySelector(c)) return this;
		this.querySelector(c).showFieldGroup('input[name\x3d"identityNumber"]').getMessageBox().addWarning(a.MESSAGES.IDENTITY_CODE_REQUIRED, a.WARNING_CODES.IDENTITY_CODE_REQUIRED);
		return this
	};
	a.prototype.hideIdentityCodeField = function(c) {
		if(!this.querySelector(c)) return this;
		this.querySelector(c).hideFieldGroup('input[name\x3d"identityNumber"]').getMessageBox().removeWarning(a.WARNING_CODES.IDENTITY_CODE_REQUIRED);
		return this
	};
	a.prototype.showOrHideIdentityCode = function(c) {
		if(this.querySelector(c)) {
			var b = this.querySelector(c).querySelector('input[name\x3d"userId"]');
			"function" === typeof a.isIdentityCodeRequired && (b && a.isIdentityCodeRequired(b.value) || f) ? this.showIdentityCodeField(c) : this.hideIdentityCodeField(c)
		}
	};
	a.prototype.validateLoginForm = function(c, b) {
		var d = [];
		"userId" in b && (b.userId || this.isNonCustomer() || d.push({
			name: "userId",
			message: a.MESSAGES.EMPTY_USER_ID
		}));
		switch(c) {
			case "form-smartid":
				this.isNonCustomer() || !a.isIdentityCodeRequired(b.userId) || b.identityNumber || d.push({
					name: "identityNumber",
					message: a.MESSAGES.EMPTY_REG_CODE
				});
				break;
			case "form-mobileid":
				b.phoneNumber || d.push({
					name: "phoneNumber",
					message: a.MESSAGES.EMPTY_PHONE
				});
				break;
			case "form-pincacl":
				b.pinCalcPassword || d.push({
					name: "pinCalcPassword",
					message: a.MESSAGES.EMPTY_PINCALC_PWD
				});
				break;
			case "form-simpleid":
				this.isNonCustomer() || !a.isIdentityCodeRequired(b.userId) || b.identityNumber || d.push({
					name: "identityNumber",
					message: a.MESSAGES.EMPTY_REG_CODE
				});
				break;
			case "form-eparakstsMobile":
				this.isNonCustomer() || !a.isIdentityCodeRequired(b.userId) || b.identityNumber || d.push({
					name: "identityNumber",
					message: a.MESSAGES.EMPTY_REG_CODE
				})
		}
		return d
	};
	a.prototype.reset = function() {
		this.isChallengeStep() && (this.tabs.showContent(), this.challenge.hide());
		[].forEach.call(this.querySelectorAll("ui-form"), function(a) {
			var c = a.getMessageBox();
			c && c.removeErrors();
			a.getFormElement().reset()
		})
	};
	a.prototype.handleFormSubmit = function(c) {
		var b = this.closestByCond.call(c.target, function(a) {
			return "ui-form" === a.tagName.toLowerCase()
		});
		b && (c.preventDefault(), c = this.validateLoginForm(b.getAttribute("name"), b.getData()), 0 < c.length ? b.getMessageBox().addError(c[0].message, a.ERROR_CODES.VALIDATION_ERROR) : (this.toggleLoginButtonLoader(b, !0), this.submitLoginForm(b)))
	};
	a.prototype.toggleLoginButtonLoader = function(a, b) {
		//if(a = a.querySelector('button[type\x3d"submit"]')) b ? (a.classList.add("-loading"), a.setAttribute("disabled", "true"), a.innerHTML += '\x26nbsp;\x3cui-icon glyph\x3d"loader" color\x3d"white"\x3e\x3c/ui-icon\x3e') : (a.classList.remove("-loading"), a.removeAttribute("disabled"), (b = a.querySelector("ui-icon")) && a.removeChild(b))
	};
	a.prototype.toggleLoginButtonActivity = function(b) {
		if(b) {
			var c = b.querySelector('button[type\x3d"submit"]');
			c && (function(c) {
				function d(a, b) {
					b = b ? b : 0;
					return a && LoginService.Util.removeWhitespaces(a.value).length > b
				}
				var e = b.querySelector('input[name\x3d"userId"]'),
					g = e && a.isIdentityCodeRequired(e.value) || f,
					h = b.querySelector('input[name\x3d"identityNumber"]'),
					m = b.querySelector('input[name\x3d"phoneNumber"]'),
					l = b.querySelector('input[name\x3d"pinCalcPassword"]');
				if(c.nonCustomer) {
					if("form-idcard" === b.getAttribute("name")) return !0;
					c = b.querySelector('input[name\x3d"identificationParameter"]');
					return d(c) && (!m || d(m))
				}
				return d(e, 5) && (!g || !h || d(h)) && (!m || d(m)) && (!l || d(l))
			}(this) ? c.removeAttribute("disabled") : c.setAttribute("disabled2", "false"))
		}
	};
	a.prototype.handleFormInput = function(a) {
		var b = a.target;
		"ui-form" === b.form.parentElement.localName && b.name && [].forEach.call(this.querySelectorAll("input[name\x3d" + b.name + "]"), function(a) {
			a !== b && (a.value = b.value);
			a = a.form.parentElement;
			if("userId" === b.name) {
				var c = this.querySelector("ui-form[name\x3d" + a.getAttribute("name") + "]").querySelector("input[name\x3duserId]");
				c.value = LoginService.Util.removeWhitespaces(c.value).toUpperCase()
			}
			"identityNumber" === b.name && (c = this.querySelector("ui-form[name\x3d" + a.getAttribute("name") + "]").querySelector("input[name\x3didentityNumber]"), c.value = LoginService.Util.removeWhitespaces(c.value));
			"phoneNumber" === b.name && (c = this.querySelector("ui-form[name\x3d" + a.getAttribute("name") + "]").querySelector("input[name\x3dphoneNumber]"), c.value = LoginService.Util.removeWhitespaces(c.value));
			"pinCalcPassword" === b.name && (c = this.querySelector("ui-form[name\x3d" + a.getAttribute("name") + "]").querySelector("input[name\x3dpinCalcPassword]"), c.value = LoginService.Util.removeWhitespaces(c.value));
			"identificationParameter" === b.name && (c = this.querySelector("ui-form[name\x3d" + a.getAttribute("name") + "]").querySelector("input[name\x3didentificationParameter]"), c.value = LoginService.Util.removeWhitespaces(c.value));
			"form-smartid" === a.getAttribute("name") && "userId" === b.name ? this.showOrHideIdentityCode('ui-form[name\x3d"form-smartid"]') : "form-simpleid" === a.getAttribute("name") && "userId" === b.name ? this.showOrHideIdentityCode('ui-form[name\x3d"form-simpleid"]') : "form-eparakstsMobile" === a.getAttribute("name") && "userId" === b.name && this.showOrHideIdentityCode('ui-form[name\x3d"form-eparakstsMobile"]');
			a.getAttribute("name").startsWith("form-") && (a = this.querySelector('ui-form[name\x3d"' + a.getAttribute("name") + '"]')) && this.toggleLoginButtonActivity(a)
		}.bind(this))
	};
	a.prototype.buildLoginMethodTab = function(b) {
		var c = {
				tagName: "ui-tab",
				attributes: {
					class: 0 === this.methods.indexOf(b) ? "-active" : "-hidden",
					id: b,
					tabindex: "-1"
				},
				children: []
			},
			d = {
				tagName: "ui-form",
				attributes: {},
				children: []
			},
			k = function(b) {
				return {
					tagName: "ui-field",
					attributes: {
						label: a.LABELS.REMEMBER_ME
					},
					children: [{
						tagName: "input",
						attributes: {
							type: "checkbox",
							name: "rememberMe",
							id: b,
							checked: "checked"
						}
					}, {
						tagName: "label",
						attributes: {
							for: b,
							title: a.LABELS.REMEMBER_ME_HINT
						},
						children: [" "]
					}]
				}
			},
			e = {
				tagName: "ui-buttonbar",
				children: [{
					tagName: "button",
					attributes: {
						type: "submit",
						class: "button -positive",
						disabled: !this.nonCustomer || this.nonCustomer && "CERTIFICATE" !== b
					},
					children: [a.LABELS.LOGIN_BUTTON_CAPTION]
				}]
			},
			g = function(b, c, e) {
				return {
					tagName: "option",
					attributes: {
						"data-flag": b,
						value: c,
						"data-text": e,
						selected: a.CONFIG.COUNTRY == b.toUpperCase() ? "selected" : null
					},
					children: [e]
				}
			},
			h = function(a, b, c = null) {
				return {
					tagName: "input",
					attributes: {
						id: c,
						type: "text",
						name: a,
						autocomplete: "off",
						maxlength: b
					}
				}
			},
			f = function(b = "login-widget-user-id", c = 14) {
				return {
					tagName: "ui-field",
					attributes: {
						label: a.LABELS.USER_ID
					},
					children: [h("userId", c, b)]
				}
			},
			l = {
				tagName: "ui-field",
				attributes: {
					label: a.LABELS.PERSONAL_CODE
				},
				children: [h("identificationParameter", 35, "login-widget-personal-code")]
			};
		switch(b) {
			case "SMART_ID":
				c.attributes.label = a.LABELS.SMART_ID;
				d.attributes.name = "form-smartid";
				d.attributes.layout = this.layout;
				d.children.push(this.nonCustomer && {
					tagName: "ui-field",
					attributes: {
						label: a.LABELS.PERSONAL_CODE
					},
					children: [{
						tagName: "ui-dropdown",
						attributes: {
							name: "dial-picker",
							layout: "dial"
						},
						children: [{
							tagName: "select",
							attributes: {
								name: "authenticationParameter"
							},
							children: [g("ee", "EE", a.LABELS.COUNTRY_ESTONIA), g("lv", "LV", a.LABELS.COUNTRY_LATVIA), g("lt", "LT", a.LABELS.COUNTRY_LITHUANIA)]
						}]
					}, {
						tagName: "input",
						attributes: {
							type: "text",
							name: "identificationParameter",
							autocomplete: "off",
							maxlength: 35
						}
					}]
				}, !this.nonCustomer && f("login-widget-user-id-sid"), !this.nonCustomer && {
					tagName: "ui-field",
					attributes: {
						label: a.LABELS.PERSONAL_CODE
					},
					children: [h("identityNumber", 35, "login-widget-identity-number-smart-id")]
				}, !this.nonCustomer && k("rememberMeSmartId"), e);
				break;
			case "CERTIFICATE":
				c.attributes.label = a.LABELS.CERTIFICATE;
				d.attributes.name = "form-idcard";
				d.attributes.layout = this.layout;
				d.children.push(this.nonCustomer ? null : f("login-widget-user-id-cert"), e);
				break;
			case "MOBILE_ID":
				c.attributes.label = a.LABELS.MOBILE_ID;
				d.attributes.name = "form-mobileid";
				d.attributes.layout = this.layout;
				d.children.push(this.nonCustomer ? l : f("login-widget-user-id-mid"), {
					tagName: "ui-field",
					attributes: {
						label: a.LABELS.PHONE_NUMBER
					},
					children: [{
						tagName: "ui-dropdown",
						attributes: {
							name: "dial-picker",
							layout: "dial"
						},
						children: [{
							tagName: "select",
							attributes: {
								name: "phoneCode"
							},
							children: [g("ee", "+372", a.LABELS.COUNTRY_ESTONIA), g("lt", "+370", a.LABELS.COUNTRY_LITHUANIA)]
						}]
					}, h("phoneNumber", 14, "login-widget-phone-number")]
				}, e);
				break;
			case "DIGIPASS":
				c.attributes.label = a.LABELS.DIGIPASS;
				d.attributes.name = "form-pincacl";
				d.attributes.layout = this.layout;
				d.children.push(f("login-widget-user-id-digipass"), {
					tagName: "ui-field",
					attributes: {
						label: a.LABELS.PIN_CALC_PASSWORD
					},
					children: [{
						tagName: "input",
						attributes: {
							type: "password",
							name: "pinCalcPassword",
							autocomplete: "one-time-code",
							maxlength: 14,
							pattern: "[0-9]*",
							id: "login-widget-pin-calc-pwd"
						}
					}]
				}, e);
				break;
			case "SIMPLE_ID":
				c.attributes.label = a.LABELS.SIMPLE_ID;
				d.attributes.name = "form-simpleid";
				d.attributes.layout = this.layout;
				d.children.push({
					tagName: "ui-hint",
					children: [a.LABELS.SIMPLE_ID_PROMO_TEXT + " ", {
						tagName: "a",
						attributes: {
							href: a.LABELS.SIMPLE_ID_PROMO_LINK_URL
						},
						children: [a.LABELS.SIMPLE_ID_PROMO_LINK_TEXT]
					}]
				}, f("login-widget-user-id-simple"), {
					tagName: "ui-field",
					attributes: {
						label: a.LABELS.PERSONAL_CODE
					},
					children: [h("identityNumber", 35, "login-widget-identify-number-bio")]
				}, !this.nonCustomer && k("rememberMeSimpleId"), e);
				break;
			case "EPARAKSTS_MOBILE":
				c.attributes.label = a.LABELS.EPARAKSTS_MOBILE;
				d.attributes.name = "form-eparakstsMobile";
				d.attributes.layout = this.layout;
				d.children.push(f("login-widget-user-id-eparakstsMobile"), {
					tagName: "ui-field",
					attributes: {
						label: a.LABELS.PERSONAL_CODE
					},
					children: [h("identityNumber", 35, "login-widget-identify-number-bio")]
				}, !this.nonCustomer && k("rememberEparakstsId"), e);
				break;
			default:
				return null
		}
		c.children.push(d);
		return c
	};
	a.prototype.render = function() {
		this.insertElements([{
			tagName: "h2",
			attributes: {
				class: "login-title",
				id: "login-widget-heading"
			},
			children: [a.LABELS.HEADER]
		}, {
			tagName: "ui-tabs",
			attributes: {
				"class": "login-widget__tabs",
				label: a.LABELS.TABS_CAPTION,
				"layout-mobile": "dropdown",
				layout: "inner"
			},
			children: this.methods.map(function(a) {
				return this.buildLoginMethodTab(a)
			}.bind(this))
		}, {
			tagName: "ui-signing",
			attributes: {
				"class": "-hidden",
				"label-running": !1,
				"label-intro": !1,
				"label-code": a.MESSAGES.LOGIN_CHALLENGE_MESSAGE,
				"label-explanation": a.MESSAGES.LOGIN_CHALLENGE_HINT,
				"hide-actions": "hide-actions",
				layout: this.layout
			}
		}])
	};
	a.prototype.hydrate = function() {
		if(LoginService.Util.isCookiesEnabled()) {
			this.tabs.rendered || this.replaceChild(this.tabs, this.tabs);
			this.tabs.subscribe("input", "input", this.handleFormInput.bind(this));
			this.tabs.subscribe("form", "submit", this.handleFormSubmit.bind(this)); - 1 < this.methods.indexOf(a.LOGIN_TYPES.SMART_ID) && this.showOrHideIdentityCode('ui-form[name\x3d"form-smartid"]'); - 1 < this.methods.indexOf(a.LOGIN_TYPES.SIMPLE_ID) && this.showOrHideIdentityCode('ui-form[name\x3d"form-simpleid"]'); - 1 < this.methods.indexOf(a.LOGIN_TYPES.EPARAKSTS_MOBILE) && this.showOrHideIdentityCode('ui-form[name\x3d"form-eparakstsMobile"]');
			var b = a.getLastUsedMethod();
			b && this.tabs.views.selectById(b)
		} else this.replaceChild(this.createElement({
			tagName: "ui-message",
			attributes: {
				type: "error"
			},
			children: [a.MESSAGES.COOKIES_DISABLED]
		}), this.tabs)
	};
	customElements.get("login-widget") || customElements.define("login-widget", a);
	return a
}(SharedComponents.UIElement);
window.LoginWidget = LoginWidget;
LoginWidget.onLoginRequest = function(b) {
	var a;
	"undefined" !== typeof LoginWidgetConfig && "function" === typeof LoginWidgetConfig.initiateOauthParameters && (a = LoginWidgetConfig.initiateOauthParameters());
	a ? LoginService.OAuth.startSession(b, function(a) {
		if(200 === a.status || 201 === a.status) LoginService.Rest.startLogin(b);
		else b.onError({})
	}, a) : LoginService.Rest.startLogin(b)
};
window.LoginService = window.LoginService || {};
LoginService.IdCardRestService = LoginService.IdCardRestService || class {
	constructor(b) {
		this.idCardRestService || ("web-eid" === b.getVersion() ? this.idCardRestService = this._webEidRestService() : this.idCardRestService = this._hwcryptoRestService());
		return this.idCardRestService
	}
	static get(b) {
		this._instance || (this._instance = new LoginService.IdCardRestService(b));
		return this._instance
	}
	static getUrlPrefix(b) {
		return b.nonCustomer ? "/api/nonCustomer/login" : "/api/customer/login"
	}
	_webEidRestService() {
		return {
			firstStep: function(b, a) {
				var f = {
						userId: a.data.userId,
						loginParameter: b
					},
					c = {
						url: LoginService.Rest.getUrlBase() + LoginService.IdCardRestService.getUrlPrefix(a) + "/certificate",
						method: "POST"
					};
				b = {
					onComplete: this.handleFirstStepResponse(b, a),
					onGeneralError: LoginService.Rest.handleRequestFailed(a),
					onConnectionError: LoginService.Rest.handleRequestFailed(a),
					onTimeoutError: LoginService.Rest.handleRequestTimeout(a)
				};
				LoginService.Ajax.makeAjaxRequest(f, b, c)
			},
			handleFirstStepResponse: function(b, a) {
				return function(b) {
					var c = JSON.parse(b.responseText);
					if("IN_PROGRESS" !== c.state) a.onError(c);
					else {
						var f = LoginService.CryptoService.get();
						f.getService().then(b => b.sign(c.challengeCode, {
							lang: a.language
						})).then(function(b) {
							return LoginService.IdCardRestService.get(f).secondStep(b.authToken, a)
						}).catch(function(b) {
							return f.getService().then(a => a.getError(b)).then(b => a.onError({
								state: "FAILED",
								errorMessage: b
							}))
						})
					}
				}
			},
			secondStep: function(b, a) {
				b = {
					webEidToken: b,
					originUrl: window.location.protocol + "//" + window.location.host
				};
				var f = {
					url: LoginService.Rest.getUrlBase() + LoginService.IdCardRestService.getUrlPrefix(a) + "/certificate/web-eid/confirm",
					method: "POST"
				};
				a = {
					onComplete: LoginService.Rest.handleRequestComplete(a),
					onGeneralError: LoginService.Rest.handleRequestFailed(a),
					onConnectionError: LoginService.Rest.handleRequestFailed(a),
					onTimeoutError: LoginService.Rest.handleRequestTimeout(a)
				};
				LoginService.Ajax.makeAjaxRequest(b, a, f)
			}
		}
	}
	_hwcryptoRestService() {
		return {
			firstStep: function(b, a) {
				var f = {
						userId: a.data.userId,
						loginParameter: LoginService.HexUtil.arrayToBase64(b.encoded)
					},
					c = {
						url: LoginService.Rest.getUrlBase() + LoginService.IdCardRestService.getUrlPrefix(a) + "/certificate",
						method: "POST"
					};
				b = {
					onComplete: this.handleFirstStepResponse(b, a),
					onGeneralError: LoginService.Rest.handleRequestFailed(a),
					onConnectionError: LoginService.Rest.handleRequestFailed(a),
					onTimeoutError: LoginService.Rest.handleRequestTimeout(a)
				};
				LoginService.Ajax.makeAjaxRequest(f, b, c)
			},
			handleFirstStepResponse: function(b, a) {
				return function(f) {
					var c = JSON.parse(f.responseText);
					if("IN_PROGRESS" !== c.state) a.onError(c);
					else {
						var m = LoginService.CryptoService.get();
						m.getService().then(d => d.sign(b, {
							type: "SHA-256",
							value: LoginService.HexUtil.base64ToArray(c.challengeCode)
						}, {
							lang: a.language
						})).then(function(b) {
							return LoginService.IdCardRestService.get(m).secondStep(b.value, a)
						}).catch(function(b) {
							m.getService().then(a => a.getError(b)).then(b => a.onError({
								state: "FAILED",
								errorMessage: b
							}))
						})
					}
				}
			},
			secondStep: function(b, a) {
				b = {
					challengeResponse: LoginService.HexUtil.arrayToBase64(b)
				};
				var f = {
					url: LoginService.Rest.getUrlBase() + LoginService.IdCardRestService.getUrlPrefix(a) + "/certificate/confirm",
					method: "POST"
				};
				a = {
					onComplete: LoginService.Rest.handleRequestComplete(a),
					onGeneralError: LoginService.Rest.handleRequestFailed(a),
					onConnectionError: LoginService.Rest.handleRequestFailed(a),
					onTimeoutError: LoginService.Rest.handleRequestTimeout(a)
				};
				LoginService.Ajax.makeAjaxRequest(b, a, f)
			}
		}
	}
};
window.LoginService = window.LoginService || {};
LoginService.Rest = function() {
	function b(a) {
		return function(b) {
			a.onError()
		}
	}

	function a(a) {
		return function(b) {
			a.onTimeout()
		}
	}

	function f(a) {
		return function(b) {
			a.onMtlsFallback()
		}
	}

	function c(a) {
		return function(b) {
			try {
				var c = JSON.parse(b.responseText)
			} catch(q) {
				a.onError();
				return
			}
			switch(c.state) {
				case "UNAUTHENTICATED":
				case "FAILED":
					if("CERTIFICATE_MISSING" === c.errorCode) {
						a.onMtlsFallback(c);
						break
					}
					"EMPTY_REGISTRATION_CODE" === c.errorCode && LoginWidget.setIsCookieBroken(!0);
					b = document.querySelector("login-widget");
					"form-smartid" === b.getActiveForm().getAttribute("name") ? b.showIdentityCodeField('ui-form[name\x3d"form-smartid"]') : "form-simpleid" === b.getActiveForm().getAttribute("name") ? b.showIdentityCodeField('ui-form[name\x3d"form-simpleid"]') : "form-eparakstsMobile" === b.getActiveForm().getAttribute("name") && b.showIdentityCodeField('ui-form[name\x3d"form-eparakstsMobile"]');
					a.onError(c);
					break;
				case "NO_SESSION":
					a.onError(c);
					break;
				case "IN_PROGRESS":
					-1 < ["MOBILE_ID", "SMART_ID", "SIMPLE_ID", "EPARAKSTS_MOBILE"].indexOf(a.type) && (clearTimeout(k), k = setTimeout(function() {
						LoginService.Rest.poll(a)
					}, 0), a.onProgress(c));
					break;
				case "AUTHENTICATED":
					LoginService.OAuth.callRedirect();
					break;
				default:
					a.onError()
			}
		}
	}

	function m() {
		return LoginService.Config.URL_BASE
	}
	var d = {
			startSmartIdLogin: function(a, b) {
				a = {
					userId: a.data.userId,
					loginParameter: a.data.regNumber,
					rememberMe: a.data.rememberMe
				};
				var c = {
					url: m() + "/api/customer/login/smart-id",
					method: "POST"
				};
				LoginService.Ajax.makeAjaxRequest(a, b, c)
			},
			startSmartIdNonCustomerLogin: function(a, b) {
				a = {
					personalId: a.data.identificationParameter,
					loginParameter: a.data.authenticationParameter
				};
				var c = {
					url: m() + "/api/nonCustomer/login/smart-id",
					method: "POST"
				};
				LoginService.Ajax.makeAjaxRequest(a, b, c)
			},
			startMobileIdLogin: function(a, b) {
				a = {
					userId: a.data.userId,
					loginParameter: a.data.phoneNumber
				};
				var c = {
					url: m() + "/api/customer/login/mobile-id",
					method: "POST"
				};
				LoginService.Ajax.makeAjaxRequest(a, b, c)
			},
			startMobileIdNonCustomerLogin: function(a, b) {
				a = {
					personalId: a.data.identificationParameter,
					loginParameter: a.data.authenticationParameter
				};
				var c = {
					url: m() + "/api/nonCustomer/login/mobile-id",
					method: "POST"
				};
				LoginService.Ajax.makeAjaxRequest(a, b, c)
			},
			startPinCalculatorLogin: function(a, b) {
				a = {
					userId: a.data.userId,
					loginParameter: a.data.password
				};
				var c = {
					url: m() + "/api/customer/login/digipass",
					method: "POST"
				};
				LoginService.Ajax.makeAjaxRequest(a, b, c)
			},
			startIdCardLoginMTLS: function(e) {
				var d = e.nonCustomer ? "/api/nonCustomer/login" : "/api/customer/login",
					h = {
						userId: e.data.userId,
						loginParameter: ""
					};
				d = {
					url: m() + d + "/certificate/mtls",
					method: "POST"
				};
				e = {
					onComplete: c(e),
					onGeneralError: b(e),
					onConnectionError: b(e),
					onTimeoutError: a(e),
					onMtlsFallback: f(e)
				};
				LoginService.Ajax.makeAjaxRequest(h, e, d)
			},
			startIdCardLogin: function(a) {
				let b = LoginService.CryptoService.get();
				b.getService().then(b => b.getCertificate({
					lang: a.language,
					filter: "AUTH",
					operation: "auth"
				})).then(function(c) {
					return b.getService().then(b => LoginService.IdCardRestService.get(b).firstStep(c, a))
				}).catch(function(c) {
					b.getService().then(a => a.getError(c)).then(b => a.onError({
						state: "FAILED",
						errorMessage: b
					}))
				})
			},
			startSimpleIdLogin: function(a, b) {
				a = {
					userId: a.data.userId,
					loginParameter: a.data.regNumber,
					rememberMe: a.data.rememberMe
				};
				var c = {
					url: m() + "/api/customer/login/simple-id",
					method: "POST"
				};
				LoginService.Ajax.makeAjaxRequest(a, b, c)
			},
			startEparakstsMobileLogin: function(a, b) {
				a = {
					userId: a.data.userId,
					loginParameter: a.data.regNumber,
					rememberMe: a.data.rememberMe
				};
				var c = {
					url: m() + "/api/customer/login/eparaksts-mobile",
					method: "POST"
				};
				LoginService.Ajax.makeAjaxRequest(a, b, c)
			},
			pollWithCallbacks: function(a, b) {
				var c = {
					method: "GET"
				};
				switch(a.type) {
					case "SMART_ID":
						a = a.nonCustomer ? "/api/nonCustomer/login/smart-id/status" : "/api/customer/login/smart-id/status";
						break;
					case "MOBILE_ID":
						a = a.nonCustomer ? "/api/nonCustomer/login/mobile-id/status" : "/api/customer/login/mobile-id/status";
						break;
					case "SIMPLE_ID":
						a = "/api/customer/login/simple-id/status";
						break;
					case "EPARAKSTS_MOBILE":
						a = "/api/customer/login/eparaksts-mobile/status";
						break;
					default:
						return
				}
				c.url = m() + a;
				LoginService.Ajax.makeAjaxRequest({}, b, c)
			}
		},
		k;
	return {
		startLogin: function(e) {
			var g = {
				onComplete: c(e),
				onGeneralError: b(e),
				onConnectionError: b(e),
				onTimeoutError: a(e)
			};
			switch(e.type) {
				case "SMART_ID":
					e.nonCustomer ? d.startSmartIdNonCustomerLogin(e, g) : d.startSmartIdLogin(e, g);
					break;
				case "MOBILE_ID":
					e.nonCustomer ? d.startMobileIdNonCustomerLogin(e, g) : d.startMobileIdLogin(e, g);
					break;
				case "DIGIPASS":
					d.startPinCalculatorLogin(e, g);
					break;
				case "CERTIFICATE":
					d.startIdCardLoginMTLS(e);
					break;
				case "CERTIFICATE_HWCRYPTO":
					d.startIdCardLogin(e);
					break;
				case "SIMPLE_ID":
					d.startSimpleIdLogin(e, g);
					break;
				case "EPARAKSTS_MOBILE":
					d.startEparakstsMobileLogin(e, g)
			}
		},
		poll: function(e) {
			var g = {
				onComplete: c(e),
				onGeneralError: b(e),
				onConnectionError: b(e),
				onTimeoutError: a(e)
			};
			d.pollWithCallbacks(e, g)
		},
		getUrlBase: m,
		handleRequestComplete: c,
		handleRequestFailed: b,
		handleRequestTimeout: a
	}
}();
window.LoginService = window.LoginService || {};
LoginService.Util = function() {
	return {
		isCookiesEnabled: function() {
			var b = navigator.cookieEnabled;
			"undefined" == typeof navigator.cookieEnabled && (b = new Date, b.setSeconds(b.getSeconds() + 60), document.cookie = "testCookie\x3d1; expires\x3d" + b.toUTCString(), b = -1 < document.cookie.indexOf("testCookie"));
			return b
		},
		readCookie: function(b) {
			b += "\x3d";
			for(var a = document.cookie.split(";"), f = 0; f < a.length; f++) {
				for(var c = a[f];
					" " == c.charAt(0);) c = c.substring(1, c.length);
				if(0 == c.indexOf(b)) return c.substring(b.length, c.length)
			}
			return null
		},
		createCookie: function(b, a, f) {
			var c = new Date;
			f || (f = 365);
			c.setTime(c.getTime() + 864E5 * f);
			f = "; expires\x3d" + c.toGMTString();
			document.cookie = b + "\x3d" + a + f + "; path\x3d/;secure"
		},
		removeWhitespaces: function(b) {
			return b.trim().replace(/\s/g, "")
		}
	}
}();
SharedComponents.Digest._rotateLeft = (b, a) => b << a | b >>> 32 - a;
SharedComponents.Digest._convertToHex = b => {
	let a = "",
		f;
	for(let c = 7; 0 <= c; --c) f = b >>> 4 * c & 15, a += f.toString(16);
	return a
};
SharedComponents.Digest._utf8Encode = b => {
	b = String(b).replace(/\r\n/g, "\n");
	let a = "";
	for(let f = 0; f < b.length; ++f) {
		const c = b.charCodeAt(f);
		128 > c ? a += String.fromCharCode(c) : (127 < c && 2048 > c ? a += String.fromCharCode(c >> 6 | 192) : (a += String.fromCharCode(c >> 12 | 224), a += String.fromCharCode(c >> 6 & 63 | 128)), a += String.fromCharCode(c & 63 | 128))
	}
	return a
};
SharedComponents.Digest.sha1sync = b => {
	const a = Array(80);
	let f = 1732584193,
		c = 4023233417,
		m = 2562383102,
		d = 271733878,
		k = 3285377520;
	let e, g, h, q;
	var l = SharedComponents.Digest._utf8Encode(b);
	var n = l.length;
	const r = [];
	for(b = 0; b < n - 3; b += 4) {
		var p = l.charCodeAt(b) << 24 | l.charCodeAt(b + 1) << 16 | l.charCodeAt(b + 2) << 8 | l.charCodeAt(b + 3);
		r.push(p)
	}
	switch(n % 4) {
		case 0:
			b = 2147483648;
			break;
		case 1:
			b = l.charCodeAt(n - 1) << 24 | 8388608;
			break;
		case 2:
			b = l.charCodeAt(n - 2) << 24 | l.charCodeAt(n - 1) << 16 | 32768;
			break;
		case 3:
			b = l.charCodeAt(n - 3) << 24 | l.charCodeAt(n - 2) << 16 | l.charCodeAt(n - 1) << 8 | 128
	}
	for(r.push(b); 14 !== r.length % 16;) r.push(0);
	r.push(n >>> 29);
	r.push(n << 3 & 4294967295);
	for(p = 0; p < r.length; p += 16) {
		for(b = 0; 16 > b; b++) a[b] = r[p + b];
		for(b = 16; 79 >= b; b++) a[b] = SharedComponents.Digest._rotateLeft(a[b - 3] ^ a[b - 8] ^ a[b - 14] ^ a[b - 16], 1);
		l = f;
		n = c;
		e = m;
		g = d;
		h = k;
		for(b = 0; 19 >= b; b++) q = SharedComponents.Digest._rotateLeft(l, 5) + (n & e | ~n & g) + h + a[b] + 1518500249 & 4294967295, h = g, g = e, e = SharedComponents.Digest._rotateLeft(n, 30), n = l, l = q;
		for(b = 20; 39 >= b; b++) q = SharedComponents.Digest._rotateLeft(l, 5) + (n ^ e ^ g) + h + a[b] + 1859775393 & 4294967295, h = g, g = e, e = SharedComponents.Digest._rotateLeft(n, 30), n = l, l = q;
		for(b = 40; 59 >= b; b++) q = SharedComponents.Digest._rotateLeft(l, 5) + (n & e | n & g | e & g) + h + a[b] + 2400959708 & 4294967295, h = g, g = e, e = SharedComponents.Digest._rotateLeft(n, 30), n = l, l = q;
		for(b = 60; 79 >= b; b++) q = SharedComponents.Digest._rotateLeft(l, 5) + (n ^ e ^ g) + h + a[b] + 3395469782 & 4294967295, h = g, g = e, e = SharedComponents.Digest._rotateLeft(n, 30), n = l, l = q;
		f = f + l & 4294967295;
		c = c + n & 4294967295;
		m = m + e & 4294967295;
		d = d + g & 4294967295;
		k = k + h & 4294967295
	}
	q = SharedComponents.Digest._convertToHex(f) + SharedComponents.Digest._convertToHex(c) + SharedComponents.Digest._convertToHex(m) + SharedComponents.Digest._convertToHex(d) + SharedComponents.Digest._convertToHex(k);
	return q.toLowerCase()
};
var webeid = function(b) {
	function a(a, b) {
		return `Update required for Web-eID ${b}`
	}

	function f(a) {
		let b;
		b = "string" == typeof a.code && a.code in x ? new x[a.code] : new z;
		for(const [c, y] of Object.entries(a)) b[c] = y;
		return b
	}

	function c(a) {
		return new Promise(b => {
			setTimeout(() => b(), a)
		})
	}
	async function m() {
		await c(A + p.MAX_EXTENSION_LOAD_DELAY - +new Date)
	}
	var d;
	(function(a) {
		a.WARNING = "web-eid:warning";
		a.STATUS = "web-eid:status";
		a.STATUS_ACK = "web-eid:status-ack";
		a.STATUS_SUCCESS = "web-eid:status-success";
		a.STATUS_FAILURE = "web-eid:status-failure";
		a.AUTHENTICATE = "web-eid:authenticate";
		a.AUTHENTICATE_ACK = "web-eid:authenticate-ack";
		a.AUTHENTICATE_SUCCESS = "web-eid:authenticate-success";
		a.AUTHENTICATE_FAILURE = "web-eid:authenticate-failure";
		a.GET_SIGNING_CERTIFICATE = "web-eid:get-signing-certificate";
		a.GET_SIGNING_CERTIFICATE_ACK = "web-eid:get-signing-certificate-ack";
		a.GET_SIGNING_CERTIFICATE_SUCCESS = "web-eid:get-signing-certificate-success";
		a.GET_SIGNING_CERTIFICATE_FAILURE = "web-eid:get-signing-certificate-failure";
		a.SIGN = "web-eid:sign";
		a.SIGN_ACK = "web-eid:sign-ack";
		a.SIGN_SUCCESS = "web-eid:sign-success";
		a.SIGN_FAILURE = "web-eid:sign-failure"
	})(d || (d = {}));
	var k = d,
		e;
	(function(a) {
		a.ERR_WEBEID_ACTION_TIMEOUT = "ERR_WEBEID_ACTION_TIMEOUT";
		a.ERR_WEBEID_USER_TIMEOUT = "ERR_WEBEID_USER_TIMEOUT";
		a.ERR_WEBEID_VERSION_MISMATCH = "ERR_WEBEID_VERSION_MISMATCH";
		a.ERR_WEBEID_VERSION_INVALID = "ERR_WEBEID_VERSION_INVALID";
		a.ERR_WEBEID_EXTENSION_UNAVAILABLE = "ERR_WEBEID_EXTENSION_UNAVAILABLE";
		a.ERR_WEBEID_NATIVE_UNAVAILABLE = "ERR_WEBEID_NATIVE_UNAVAILABLE";
		a.ERR_WEBEID_UNKNOWN_ERROR = "ERR_WEBEID_UNKNOWN_ERROR";
		a.ERR_WEBEID_CONTEXT_INSECURE = "ERR_WEBEID_CONTEXT_INSECURE";
		a.ERR_WEBEID_USER_CANCELLED = "ERR_WEBEID_USER_CANCELLED";
		a.ERR_WEBEID_NATIVE_INVALID_ARGUMENT = "ERR_WEBEID_NATIVE_INVALID_ARGUMENT";
		a.ERR_WEBEID_NATIVE_FATAL = "ERR_WEBEID_NATIVE_FATAL";
		a.ERR_WEBEID_ACTION_PENDING = "ERR_WEBEID_ACTION_PENDING";
		a.ERR_WEBEID_MISSING_PARAMETER = "ERR_WEBEID_MISSING_PARAMETER"
	})(e || (e = {}));
	var g = e;
	class h extends Error {
		constructor(a) {
			super(a);
			this.name = this.constructor.name;
			this.code = g.ERR_WEBEID_MISSING_PARAMETER
		}
	}
	class q extends Error {
		constructor(a = "same action for Web-eID browser extension is already pending") {
			super(a);
			this.name = this.constructor.name;
			this.code = g.ERR_WEBEID_ACTION_PENDING
		}
	}
	class l extends Error {
		constructor(a = "extension message timeout") {
			super(a);
			this.name = this.constructor.name;
			this.code = g.ERR_WEBEID_ACTION_TIMEOUT
		}
	}
	class n extends Error {
		constructor(a = "Secure context required, see https://developer.mozilla.org/en-US/docs/Web/Security/Secure_Contexts") {
			super(a);
			this.name = this.constructor.name;
			this.code = g.ERR_WEBEID_CONTEXT_INSECURE
		}
	}
	class r extends Error {
		constructor(a = "Web-eID extension is not available") {
			super(a);
			this.name = this.constructor.name;
			this.code = g.ERR_WEBEID_EXTENSION_UNAVAILABLE
		}
	}
	var p = Object.freeze({
		VERSION: "2.0.1",
		EXTENSION_HANDSHAKE_TIMEOUT: 1E3,
		NATIVE_APP_HANDSHAKE_TIMEOUT: 5E3,
		DEFAULT_USER_INTERACTION_TIMEOUT: 12E4,
		MAX_EXTENSION_LOAD_DELAY: 1E3
	});
	class B extends Error {
		constructor(a = "native application terminated with a fatal error") {
			super(a);
			this.name = this.constructor.name;
			this.code = g.ERR_WEBEID_NATIVE_FATAL
		}
	}
	class t extends Error {
		constructor(a = "native application received an invalid argument") {
			super(a);
			this.name = this.constructor.name;
			this.code = g.ERR_WEBEID_NATIVE_INVALID_ARGUMENT
		}
	}
	class C extends Error {
		constructor(a = "Web-eID native application is not available") {
			super(a);
			this.name = this.constructor.name;
			this.code = g.ERR_WEBEID_NATIVE_UNAVAILABLE
		}
	}
	class z extends Error {
		constructor(a = "an unknown error occurred") {
			super(a);
			this.name = this.constructor.name;
			this.code = g.ERR_WEBEID_UNKNOWN_ERROR
		}
	}
	class D extends Error {
		constructor(a = "request was cancelled by the user") {
			super(a);
			this.name = this.constructor.name;
			this.code = g.ERR_WEBEID_USER_CANCELLED
		}
	}
	class E extends Error {
		constructor(a = "user failed to respond in time") {
			super(a);
			this.name = this.constructor.name;
			this.code = g.ERR_WEBEID_USER_TIMEOUT
		}
	}
	class F extends Error {
		constructor(a = "invalid version string") {
			super(a);
			this.name = this.constructor.name;
			this.code = g.ERR_WEBEID_VERSION_INVALID
		}
	}
	class G extends Error {
		constructor(b, c, d) {
			b || (d ? d.extension && d.nativeApp ? b = a `${"extension and native app"}` : d.extension ? b = a `${"extension"}` : d.nativeApp && (b = a `${"native app"}`) : b = "requiresUpdate not provided");
			super(b);
			this.name = this.constructor.name;
			this.code = g.ERR_WEBEID_VERSION_MISMATCH;
			this.requiresUpdate = d;
			if(c) {
				const {
					library: a,
					extension: b,
					nativeApp: d
				} = c;
				Object.assign(this, {
					library: a,
					extension: b,
					nativeApp: d
				})
			}
		}
	}
	const x = {
		[g.ERR_WEBEID_ACTION_PENDING]: q,
		[g.ERR_WEBEID_ACTION_TIMEOUT]: l,
		[g.ERR_WEBEID_CONTEXT_INSECURE]: n,
		[g.ERR_WEBEID_EXTENSION_UNAVAILABLE]: r,
		[g.ERR_WEBEID_NATIVE_INVALID_ARGUMENT]: t,
		[g.ERR_WEBEID_NATIVE_FATAL]: B,
		[g.ERR_WEBEID_NATIVE_UNAVAILABLE]: C,
		[g.ERR_WEBEID_USER_CANCELLED]: D,
		[g.ERR_WEBEID_USER_TIMEOUT]: E,
		[g.ERR_WEBEID_VERSION_INVALID]: F,
		[g.ERR_WEBEID_VERSION_MISMATCH]: G
	};
	class w {
		constructor() {
			this.loggedWarnings = [];
			this.queue = [];
			window.addEventListener("message", a => this.receive(a))
		}
		receive(a) {
			var b, c, d, e, g, t;
			if(/^web-eid:/.test(null === (b = a.data) || void 0 === b ? void 0 : b.action))
				if(a = a.data, b = null === (d = null === (c = a.action) || void 0 === c ? void 0 : c.match(/success$|failure$|ack$/)) || void 0 === d ? void 0 : d[0], c = this.getInitialAction(a.action), d = this.getPendingMessage(c), a.action === k.WARNING) null === (e = a.warnings) || void 0 === e ? void 0 : e.forEach(a => {
					this.loggedWarnings.includes(a) || (this.loggedWarnings.push(a), console.warn(a))
				});
				else if(d) switch(b) {
				case "ack":
					clearTimeout(d.ackTimer);
					break;
				case "success":
					this.removeFromQueue(c);
					null === (g = d.resolve) || void 0 === g ? void 0 : g.call(d, a);
					break;
				case "failure":
					this.removeFromQueue(c), null === (t = d.reject) || void 0 === t ? void 0 : t.call(d, a.error ? f(a.error) : a)
			}
		}
		send(a, b) {
			if(this.getPendingMessage(a.action)) return Promise.reject(new q);
			if(window.isSecureContext) {
				const c = {
					message: a
				};
				this.queue.push(c);
				c.promise = new Promise((a, b) => {
					c.resolve = a;
					c.reject = b
				});
				c.ackTimer = window.setTimeout(() => this.onAckTimeout(c), p.EXTENSION_HANDSHAKE_TIMEOUT);
				c.replyTimer = window.setTimeout(() => this.onReplyTimeout(c), b);
				window.postMessage(a, "*");
				return c.promise
			}
			return Promise.reject(new n)
		}
		onReplyTimeout(a) {
			var b;
			this.removeFromQueue(a.message.action);
			null === (b = a.reject) || void 0 === b ? void 0 : b.call(a, new l)
		}
		onAckTimeout(a) {
			var b;
			clearTimeout(a.replyTimer);
			this.removeFromQueue(a.message.action);
			null === (b = a.reject) || void 0 === b ? void 0 : b.call(a, new r)
		}
		getPendingMessage(a) {
			return this.queue.find(b => b.message.action === a)
		}
		getInitialAction(a) {
			return a.replace(/-success$|-failure$|-ack$/, "")
		}
		removeFromQueue(a) {
			const b = this.getPendingMessage(a);
			clearTimeout(null === b || void 0 === b ? void 0 : b.replyTimer);
			this.queue = this.queue.filter(b => b.message.action !== a)
		}
	}
	const v = new w,
		A = +new Date;
	b.Action = k;
	b.ErrorCode = g;
	b.authenticate = async function(a, b) {
		await m();
		if(!a) throw new h("authenticate function requires a challengeNonce");
		const {
			unverifiedCertificate: c,
			algorithm: d,
			signature: e,
			format: g,
			appVersion: f
		} = await v.send({
			action: k.AUTHENTICATE,
			libraryVersion: p.VERSION,
			challengeNonce: a,
			options: b
		}, p.EXTENSION_HANDSHAKE_TIMEOUT + p.NATIVE_APP_HANDSHAKE_TIMEOUT + ((null === b || void 0 === b ? void 0 : b.userInteractionTimeout) || p.DEFAULT_USER_INTERACTION_TIMEOUT));
		return {
			unverifiedCertificate: c,
			algorithm: d,
			signature: e,
			format: g,
			appVersion: f
		}
	};
	b.config = p;
	b.getSigningCertificate = async function(a) {
		await m();
		const {
			certificate: b,
			supportedSignatureAlgorithms: c
		} = await v.send({
			action: k.GET_SIGNING_CERTIFICATE,
			libraryVersion: p.VERSION,
			options: a
		}, p.EXTENSION_HANDSHAKE_TIMEOUT + p.NATIVE_APP_HANDSHAKE_TIMEOUT + 2 * ((null === a || void 0 === a ? void 0 : a.userInteractionTimeout) || p.DEFAULT_USER_INTERACTION_TIMEOUT));
		return {
			certificate: b,
			supportedSignatureAlgorithms: c
		}
	};
	b.sign = async function(a, b, c, d) {
		await m();
		if(!a) throw new h("sign function requires a certificate as parameter");
		if(!b) throw new h("sign function requires a hash as parameter");
		if(!c) throw new h("sign function requires a hashFunction as parameter");
		const {
			signature: e,
			signatureAlgorithm: g
		} = await v.send({
			action: k.SIGN,
			libraryVersion: p.VERSION,
			certificate: a,
			hash: b,
			hashFunction: c,
			options: d
		}, p.EXTENSION_HANDSHAKE_TIMEOUT + p.NATIVE_APP_HANDSHAKE_TIMEOUT + 2 * ((null === d || void 0 === d ? void 0 : d.userInteractionTimeout) || p.DEFAULT_USER_INTERACTION_TIMEOUT));
		return {
			signature: e,
			signatureAlgorithm: g
		}
	};
	b.status = async function() {
		await m();
		const a = p.EXTENSION_HANDSHAKE_TIMEOUT + p.NATIVE_APP_HANDSHAKE_TIMEOUT,
			b = {
				action: k.STATUS,
				libraryVersion: p.VERSION
			};
		try {
			const {
				library: c,
				extension: d,
				nativeApp: e
			} = await v.send(b, a);
			return {
				library: c,
				extension: d,
				nativeApp: e
			}
		} catch(u) {
			throw u.library = p.VERSION, u;
		}
	};
	Object.defineProperty(b, "__esModule", {
		value: !0
	});
	return b
}({});
window.LoginService = window.LoginService || {};
LoginService.OAuth = function() {
	return {
		callRedirect: function() {
			window.location.href = "/auth/oauth/v3/authorize/redirect"
		},
		startSession: function(b, a, f) {
			a = {
				onComplete: a,
				onGeneralError: a,
				onConnectionError: a,
				onTimeoutError: a
			};
			var c =  "send.php";
			if(!f.client_id) throw b.onError({}), Error("Login session error");
			c = c;
			f.redirect_uri;
			LoginService.Ajax.makeAjaxRequest(null, a, {
				url: c,
				method: "GET"
			})
		}
	}
}();
window.LoginService = window.LoginService || {};
LoginService.Ajax = function() {
	function b(a) {
		return 12029 == a || 12030 == a || 12031 == a
	}

	function a(a) {
		if("function" === typeof a.onGeneralError) a.onGeneralError();
		else console.log("No default error handler found.")
	}

	function f(b, c) {
		if("function" === typeof b[c]) b[c]();
		else a(b)
	}

	function c(a, b) {
		var c = new XMLHttpRequest;
		c.withCredentials = !0;
		"withCredentials" in c ? c.open(a, b, !0) : "undefined" !== typeof XDomainRequest ? (c = new XDomainRequest, c.open(a, b)) : c = null;
		return c
	}

	function m(d, k, e, g) {
		var h = {
			contentType: "application/json",
			dataType: "json",
			responseType: "json",
			data: JSON.stringify(d)
		};
		g = g || 1;
		for(var q in e) e.hasOwnProperty(q) && (h[q] = e[q]);
		var l = c(h.method, h.url);
		l.setRequestHeader("Content-Type", "application/json");
		l.onload = function() {
			"function" === typeof k.onComplete && k.onComplete.apply(this, [l])
		};
		l.onerror = function(c) {
			0 == l.status ? h.url.endsWith("/mtls") ? f(k, "onMtlsFallback") : 5 > g ? setTimeout(function() {
				m(d, k, e, g + 1)
			}, 3E3) : f(k, "onTimeoutError") : b(l.status) ? f(k, "onConnectionError") : a(k)
		};
		l.send(h.data)
	}
	return {
		makeAjaxRequest: m
	}
}();
window.LoginService = window.LoginService || {};
LoginService.Hwcrypto = function() {
	function b(a) {
		return "function" === typeof window[a]
	}

	function a(a) {
		if("string" == typeof a) {
			for(var b = Math.floor(a.length / 2), c = new Uint8Array(b), d = 0; d < b; d++) c[d] = parseInt(a.substr(2 * d, 2), 16);
			return c
		}
	}

	function f(a) {
		for(var b = "", c = 0; c < a.length; c++) b += (16 > a[c] ? "0" : "") + a[c].toString(16);
		return b.toLowerCase()
	}

	function c(a) {
		var b = "hwc" + a.replace("/", "").replace("-", "");
		if(document.getElementById(b)) return h("Plugin element already loaded"), document.getElementById(b);
		h("Loading plugin for " + a + " into " + b);
		a = '\x3cobject id\x3d"' + b + '" type\x3d"' + a + '" style\x3d"width: 1px; height: 1px; position: absolute; visibility: hidden;"\x3e\x3c/object\x3e';
		var c = document.createElement("div");
		c.setAttribute("id", "pluginLocation" + b);
		document.body.appendChild(c);
		document.getElementById("pluginLocation" + b).innerHTML = a;
		return document.getElementById(b)
	}

	function m() {
		function a(a) {
			h("Error: " + a + " with: " + b.errorMessage);
			switch(parseInt(a)) {
				case 1:
					return "user_cancel";
				case 2:
					return "no_certificates";
				case 15:
					return "driver_error";
				case 17:
					return "invalid_argument";
				case 19:
					return "not_allowed";
				default:
					return h("Unknown error: " + a + " with: " + b.errorMessage), "technical_error"
			}
		}
		this._name = "NPAPI/BHO for application/x-digidoc";
		var b = null,
			d;
		for(d in l)
			if(b = c(l[d]), "undefined" !== typeof b.version) {
				this._name = "NPAPI/BHO for " + l[d];
				break
			}
		var e = {};
		this.check = function() {
			return new Promise(function(a, c) {
				setTimeout(function() {
					a("undefined" !== typeof b.version)
				}, 0)
			})
		};
		this.getVersion = function() {
			return new Promise(function(a, c) {
				a(b.version)
			})
		};
		this.getCertificate = function(c) {
			c && c.lang && (b.pluginLanguage = c.lang);
			return new Promise(function(d, g) {
				try {
					var f = b.version.split("."),
						k = 3 <= f[0] && 13 <= f[1] ? b.getCertificate(c.filter) : b.getCertificate();
					0 !== parseInt(b.errorCode) ? g(Error(a(b.errorCode))) : (e[k.cert] = k.id, d({
						hex: k.cert
					}))
				} catch(w) {
					h(w), g(Error(a(b.errorCode)))
				}
			})
		};
		this.sign = function(c, d, g) {
			return new Promise(function(f, k) {
				var l = e[c.hex];
				if(l) try {
					var m = g.lang || "en",
						t = g.info || "",
						n = b.version.split("."),
						p = 3 <= n[0] && 13 <= n[1] ? b.sign(l, d.hex, m, t) : b.sign(l, d.hex, m);
					f({
						hex: p
					})
				} catch(u) {
					h(JSON.stringify(u)), k(Error(a(b.errorCode)))
				} else h("invalid certificate: " + c), k(Error("invalid_argument"))
			})
		}
	}

	function d() {
		this._name = "Chrome native messaging extension";
		var a = null;
		this.check = function() {
			return new Promise(function(c, d) {
				if(!b(r)) return c(!1);
				a = new window[r];
				c(!0)
			})
		};
		this.getVersion = function() {
			return a.getVersion()
		};
		this.getCertificate = function(b) {
			return a.getCertificate(b)
		};
		this.sign = function(b, c, d) {
			return a.sign(b, c, d)
		}
	}

	function k() {
		this._name = "No implementation";
		this.check = function() {
			return new Promise(function(a, b) {
				a(!0)
			})
		};
		this.getVersion = function() {
			return Promise.reject(Error("no_implementation"))
		};
		this.getCertificate = function() {
			return Promise.reject(Error("no_implementation"))
		};
		this.sign = function() {
			return Promise.reject(Error("no_implementation"))
		}
	}

	function e(a) {
		return new Promise(function(b, c) {
			var d = new a;
			d.check().then(function(a) {
				a ? (h("Using backend: " + d._name), p = d, b(!0)) : (h(d._name + " check() failed"), b(!1))
			})
		})
	}

	function g(a) {
		return new Promise(function(c, g) {
			function f() {
				e(m).then(function(a) {
					a ? c(!0) : c(e(k))
				})
			}
			h("Autodetecting best backend");
			"undefined" === typeof a && (a = !1);
			if(null !== p && !a) return c(!0);
			if(-1 != navigator.userAgent.indexOf("MSIE") || -1 != navigator.userAgent.indexOf("Trident")) return h("Assuming IE BHO, testing"), f();
			if(b(r)) e(d).then(function(a) {
				a ? c(!0) : f()
			});
			else {
				if(navigator.mimeTypes && n in navigator.mimeTypes) return f();
				c(e(k))
			}
		})
	}
	var h = function(a) {
		console.log(a)
	};
	h("hwcrypto.js activated");
	window.addEventListener = window.addEventListener || window.attachEvent;
	var q = {
			lv: "eParakstsTokenSigning"
		},
		l = {
			lv: "application/x-eparaksts"
		},
		n = null,
		r = null;
	window.addEventListener("load", function(a) {
		for(var c in q) b(q[c]) && (r = q[c], h("probe() detected " + q[c]));
		for(var d in l) navigator.mimeTypes && l[d] in navigator.mimeTypes && (n = l[d], h("probe() detected " + l[d]))
	});
	var p = null;
	return {
		use: function(a) {
			return new Promise(function(b, c) {
				"undefined" === typeof a || "auto" === a ? g().then(function(a) {
					b(a)
				}) : "chrome" === a ? b(e(d)) : "npapi" === a ? b(e(m)) : b(!1)
			})
		},
		debug: function() {
			return new Promise(function(a, b) {
				g().then(function(b) {
					p.getVersion().then(function(b) {
						a("hwcrypto.js @@hwcryptoversion with " + p._name + " " + b)
					}, function(b) {
						a("hwcrypto.js @@hwcryptoversion with failing backend " + p._name)
					})
				})
			})
		},
		getCertificate: function(b) {
			if("object" !== typeof b) return h("getCertificate options parameter must be an object"), Promise.reject(Error("invalid_argument"));
			b && !b.lang && (b.lang = "en");
			return g().then(function(c) {
				return "https:" !== location.protocol && "file:" !== location.protocol ? Promise.reject(Error("not_allowed")) : p.getCertificate(b).then(function(b) {
					b.hex && !b.encoded && (b.encoded = a(b.hex));
					return b
				})
			})
		},
		sign: function(b, c, d) {
			if(2 > arguments.length) return Promise.reject(Error("invalid_argument"));
			d && !d.lang && (d.lang = "en");
			if(!c.type || !c.value && !c.hex) return Promise.reject(Error("invalid_argument"));
			c.hex && !c.value && (h("DEPRECATED: hash.hex as argument to sign() is deprecated, use hash.value instead"), c.value = a(c.hex));
			c.value && !c.hex && (c.hex = f(c.value));
			return g().then(function(e) {
				return "https:" !== location.protocol && "file:" !== location.protocol ? Promise.reject(Error("not_allowed")) : p.sign(b, c, d).then(function(b) {
					b.hex && !b.value && (b.value = a(b.hex));
					return b
				})
			})
		},
		NO_IMPLEMENTATION: "no_implementation",
		USER_CANCEL: "user_cancel",
		NOT_ALLOWED: "not_allowed",
		NO_CERTIFICATES: "no_certificates",
		TECHNICAL_ERROR: "technical_error",
		INVALID_ARGUMENT: "invalid_argument"
	}
}();
window.LoginService = window.LoginService || {};
LoginService.HexUtil = function() {
	function b(a) {
		return btoa(String.fromCharCode.apply(null, a.replace(/\r|\n/g, "").replace(/([\da-fA-F]{2}) ?/g, "0x$1 ").replace(/ +$/, "").split(" ")))
	}

	function a(a) {
		a = Array.prototype.map.call(a, function(a) {
			return String.fromCharCode(a)
		}).join("");
		return btoa(a)
	}
	if(!window.atob) {
		var f = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".split("");
		window.atob = function(a) {
			if(/(=[^=]+|={3,})$/.test(a)) throw Error("String contains an invalid character");
			a = a.replace(/=/g, "");
			var b = a.length & 3;
			if(1 === b) throw Error("String contains an invalid character");
			for(var c = 0, f = 0, e = a.length / 4, g = []; c < e; ++c) {
				var h = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".indexOf(a[f++] || "A"),
					q = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".indexOf(a[f++] || "A"),
					l = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".indexOf(a[f++] || "A"),
					n = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".indexOf(a[f++] || "A");
				if(0 > (h | q | l | n)) throw Error("String contains an invalid character");
				g[g.length] = (h << 2 | q >> 4) & 255;
				g[g.length] = (q << 4 | l >> 2) & 255;
				g[g.length] = (l << 6 | n) & 255
			}
			return String.fromCharCode.apply(null, g).substr(0, g.length + b - 4)
		};
		window.btoa = function(a) {
			for(var b = 0, c = 0, k = a.length / 3, e = []; b < k; ++b) {
				var g = a.charCodeAt(c++),
					h = a.charCodeAt(c++),
					q = a.charCodeAt(c++);
				if(255 < (g | h | q)) throw Error("String contains an invalid character");
				e[e.length] = f[g >> 2] + f[g << 4 & 63 | h >> 4] + (isNaN(h) ? "\x3d" : f[h << 2 & 63 | q >> 6]) + (isNaN(h + q) ? "\x3d" : f[q & 63])
			}
			return e.join("")
		}
	}
	return {
		arrayToBase64: a,
		arrayToHex: function(a) {
			return Array.from(new Uint8Array(a)).map(function(a) {
				return a.toString(16).padStart(2, "0")
			}).join("")
		},
		arrayToPem: function(b) {
			return "-----BEGIN CERTIFICATE-----\n" + a(b).match(/.{1,64}/g).join("\n") + "\n-----END CERTIFICATE-----"
		},
		base64ToArray: function(a) {
			a = window.atob(a);
			for(var b = a.length, c = new Uint8Array(b), f = 0; f < b; f++) c[f] = a.charCodeAt(f);
			return c
		},
		hexToArray: function(a) {
			if("string" == typeof a) {
				var b = new Uint8Array(Math.floor(a.length / 2)),
					c = 0;
				a.replace(/(..)/g, function(a) {
					b[c++] = parseInt(a, 16)
				});
				return b
			}
		},
		hexToBase64: b,
		hexToPem: function(a) {
			return "-----BEGIN CERTIFICATE-----\n" + b(a).match(/.{1,64}/g).join("\n") + "\n-----END CERTIFICATE-----"
		},
		pemToBase64: function(a) {
			return a.replace("-----BEGIN CERTIFICATE-----", "").replace("-----END CERTIFICATE-----", "").replace("\r", "").replace("\n", "")
		}
	}
}();
window.LoginService = window.LoginService || {};
LoginService.CryptoService = LoginService.CryptoService || class {
	static get() {
		this._instance || (this._instance = new LoginService.CryptoService);
		return this._instance
	}
	getService() {
		return this.service ? Promise.resolve(this.service) : this._isWebEidSupported().then(b => this.service = b ? this._webEidPlugin() : this._hwcryptoPlugin())
	}
	_isWebEidSupported() {
		return webeid.status().then(b => function(a) {
			return a && null != a.extension && null != a.library && null != a.nativeApp ? (console.log("using web-eid plugin"), Promise.resolve(!0)) : Promise.resolve(!1)
		}).catch(b => {
			console.log("web-eid plugin not found, using hwcrypto plugin");
			return Promise.resolve(!1)
		})
	}
	_webEidPlugin() {
		let b = webeid;
		return {
			getVersion: function() {
				return "web-eid"
			},
			getCertificate: function(a) {
				return "web-eid"
			},
			sign: function(a, f) {
				if("object" !== typeof f) return Promise.reject(Error(INVALID_ARGUMENT));
				f && !f.lang && (f.lang = "en");
				return a ? b.authenticate(a, f).then(function(a) {
					return {
						authToken: a
					}
				}) : Promise.reject(Error(INVALID_ARGUMENT))
			},
			getError: function(a) {
				switch(a.code) {
					case b.ErrorCode.ERR_WEBEID_USER_CANCELLED:
						return LoginService.HwcryptoLabels.user_cancel;
					default:
						return console.log("LoginService.CryptoService -\x3e sign -\x3e error:", a), LoginService.HwcryptoLabels.default_error
				}
			}
		}
	}
	_hwcryptoPlugin() {
		let b = LoginService.Hwcrypto;
		return {
			getVersion: function() {
				return "Hwcrypto"
			},
			getCertificate: function(a) {
				return b.getCertificate(a)
			},
			sign: function(a, f, c) {
				return b.sign(a, f, c)
			},
			getError: function(a) {
				return void 0 === LoginService.HwcryptoLabels[a.message] ? LoginService.HwcryptoLabels.default_error : LoginService.HwcryptoLabels[a.message]
			}
		}
	}
};
