//Baltic UI Web Components v2.35.3 (built with ESBuild v0.23.0)
(() => {
  // src/shared-components/global/grammar.js
  var Grammar = class _Grammar {
    /**
     * @type {{SINGULAR: number, FIVE_AND_ABOVE_PLURAL: number, ZERO_TEN: number, PLURAL: number}}
     */
    static get quantity() {
      return {
        ZERO_TEN: 0,
        SINGULAR: 1,
        PLURAL: 2,
        FIVE_AND_ABOVE_PLURAL: 5
      };
    }
    /**
     * @param {number} quantity
     * @param {string} [language]
     * @returns {number}
     */
    static quantify(quantity, language = "") {
      const remainder = quantity % 10;
      if (!language) {
        language = window["UI"] && window["UI"]["Labels"] && window["UI"]["Labels"].LANGUAGE;
      }
      switch (language || "en") {
        case "ru":
          if (remainder !== 0 && (quantity < 10 || quantity > 20)) {
            if (remainder === 1) {
              return _Grammar.quantity.SINGULAR;
            } else {
              return remainder !== 2 && remainder !== 3 && remainder !== 4 ? _Grammar.quantity.FIVE_AND_ABOVE_PLURAL : _Grammar.quantity.PLURAL;
            }
          } else {
            return _Grammar.quantity.FIVE_AND_ABOVE_PLURAL;
          }
        case "lt":
          if (remainder !== 0 && (quantity < 10 || quantity > 20)) {
            return remainder === 1 ? _Grammar.quantity.SINGULAR : _Grammar.quantity.PLURAL;
          } else {
            return _Grammar.quantity.ZERO_TEN;
          }
        default:
          return quantity === 1 ? _Grammar.quantity.SINGULAR : _Grammar.quantity.PLURAL;
      }
    }
  };

  // src/shared-components/global/labels.js
  if (!window["UI-LABELS-STORAGE"]) {
    window["UI-LABELS-STORAGE"] = {};
  }
  var labelsRegistry = window["UI-LABELS-STORAGE"];
  var Labels = Object.seal({
    LOCALE: "en",
    LANGUAGE: "en",
    /**
     * @param {string} target
     * @returns {Record<string, string>}
     */
    getAll(target) {
      if (!labelsRegistry[target]) {
        labelsRegistry[target] = {};
      }
      return labelsRegistry[target];
    },
    /**
     * @param {string} target
     * @param {UILabelType} [defaultLabels]
     * @returns {UILabelType}
     */
    attach(target, defaultLabels) {
      const data = this.getAll(target);
      if (defaultLabels) {
        Object.keys(defaultLabels).forEach((key) => {
          if (!data.hasOwnProperty(key)) {
            data[key] = defaultLabels[key];
          }
        });
      }
      return data;
    },
    /**
     * @param {string} target
     * @param {string | object} obj
     * @param {string} [label]
     */
    set(target, obj, label) {
      const data = this.getAll(target);
      if (typeof obj === "string") {
        data[obj] = label;
      } else if (typeof obj === "object") {
        Object.entries(obj).forEach(([key, value]) => {
          data[key] = value;
        });
      }
    },
    /**
     * Imports labels from third-party storage
     * @param {string} target
     * @param {Function} resolve
     * @param {Array<string>} keys
     */
    import(target, resolve, keys) {
      keys.forEach((key) => {
        const res = resolve(key);
        if (res !== key && typeof res !== "undefined") {
          this.set(target, key, res);
        }
      });
    },
    processLabel(labelStorage, key, substitutions) {
      const type = typeof substitutions;
      let quantityDefined;
      if (!labelStorage) {
        return key;
      }
      const label = labelStorage.hasOwnProperty(key) ? labelStorage[key] : key;
      switch (type) {
        case "number":
          quantityDefined = substitutions !== void 0;
          if (quantityDefined) {
            const quantifiedKey = key + "." + Grammar.quantify(substitutions);
            const rawLabel = labelStorage[quantifiedKey];
            if (rawLabel) {
              return rawLabel.replace(/%q/g, substitutions);
            }
            const singleLabel = labelStorage[key];
            return singleLabel ? singleLabel.replace(/%q/g, substitutions) : quantifiedKey;
          }
          return label;
        case "object":
          if (Array.isArray(substitutions)) {
            return substitutions.reduce((str, entry, index) => {
              return str.replace("%" + (index + 1), entry);
            }, label);
          } else {
            return Object.entries(substitutions || {}).reduce(
              (str, [key2, value]) => str.replace(`{${key2}}`, value),
              label
            );
          }
        default:
          return label;
      }
    }
  });

  // src/shared-components-labels/ui-anchor/ui-anchor.lt.js
  Labels.set("ui-anchor", "top", "Slinkite \u012F puslapio vir\u0161\u0173");
  Labels.set("ui-anchor", "bottom", "Slinkite \u012F puslapio apa\u010Di\u0105");
  Labels.set("ui-anchor", "left", "Slinkite \u012F kair\u0119");
  Labels.set("ui-anchor", "right", "Slinkite \u012F de\u0161in\u0119");

  // src/shared-components-labels/ui-annotation/ui-annotation.lt.js
  Labels.set("ui-annotation", "open", "Atidaryti anotacij\u0105");
  Labels.set("ui-annotation", "close", "U\u017Edaryti anotacij\u0105");

  // src/shared-components-labels/ui-assets/ui-assets.lt.js
  Labels.set("ui-assets", "labelMore", "Rodyti daugiau");
  Labels.set("ui-assets", "labelLess", "Rodyti ma\u017Eiau");
  Labels.set(
    "ui-assets",
    "labelToggleContent",
    "\u0160iuo metu {visibleAssets} i\u0161 {allAssets} s\u0105ra\u0161o element\u0173 matoma."
  );

  // src/shared-components-labels/ui-autocomplete/ui-autocomplete.lt.js
  Labels.set(
    "ui-autocomplete",
    "hint",
    "Use up and down arrows to review and enter to select. Touch device users, explore by touch or with swipe gestures."
  );
  Labels.set("ui-autocomplete", "results", "Results");
  Labels.set("ui-autocomplete", "resultsFound", "Results found: ");
  Labels.set("ui-autocomplete", "noResultsFound", "No results found");

  // src/shared-components-labels/ui-breadcrumbs/ui-breadcrumbs.lt.js
  Labels.set("ui-breadcrumbs", "title", "Nar\u0161ymo kelias");

  // src/shared-components-labels/ui-calendar/ui-calendar.lt.js
  Labels.set("ui-calendar", "weekDays", [
    "Pir",
    "Ant",
    "Tre",
    "Ket",
    "Pen",
    "\u0160e\u0161",
    "Sek"
  ]);
  Labels.set("ui-calendar", "weekDaysLong", [
    "Pirmadienis",
    "Antradienis",
    "Tre\u010Diadienis",
    "Ketvirtadienis",
    "Penktadienis",
    "\u0160e\u0161tadienis",
    "Sekmadienis"
  ]);
  Labels.set("ui-calendar", "prevMonth", "Praeita m\u0117nes\u012F");
  Labels.set("ui-calendar", "nextMonth", "Kit\u0105 m\u0117nes\u012F");
  Labels.set(
    "ui-calendar",
    "arrowKeys",
    "Rodykli\u0173 klavi\u0161ais galima nar\u0161yti datas"
  );

  // src/shared-components-labels/ui-chip/ui-chip.lt.js
  Labels.set("ui-chip", "close", "U\u017Edaryti");

  // src/shared-components-labels/ui-comparison-cards/ui-comparison-cards.lt.js
  Labels.set("ui-comparison-cards", "compareDetails", "Palyginti detales");
  Labels.set("ui-comparison-cards", "available", "Galimas");
  Labels.set("ui-comparison-cards", "notAvailable", "Negalimas");
  Labels.set("ui-comparison-cards", "comparisonItem1", "Palyginimo objektas 1");
  Labels.set("ui-comparison-cards", "comparisonItem2", "Palyginimo objektas 2");
  Labels.set(
    "ui-comparison-cards",
    "selectProductsCompare",
    "Pasirinkite, kuriuos produktus palyginti."
  );

  // src/shared-components-labels/ui-cookie-consent/ui-cookie-consent.lt.js
  Labels.set("ui-cookie-consent", "title", "M\u016Bs\u0173 slapukai \u2013 J\u016Bs\u0173 pasirinkimai");
  Labels.set(
    "ui-cookie-consent",
    "info",
    "\u201ESwedbank\u201C grup\u0117s {entitiesLink}, veikian\u010Dios {country}, naudoja {cookiesLink} (ar pana\u0161ias technologijas) tam, kad suteikt\u0173 Jums pritaikyt\u0105 nar\u0161ymo patirt\u012F ir pagerint\u0173 interneto svetain\u0117s veikim\u0105. Daugiau informacijos rasite m\u016Bs\u0173 {policyLink}.\n\nSpustel\u0117dami \u201ESutinku\u201C sutinkate su analitiniais ir rinkodaros slapukais, o spustel\u0117dami \u201ENesutinku\u201C j\u0173 atsisakote. Pasirenkamuosius slapukus taip pat galite valdyti \u017Eemiau. Savo sutikim\u0105 bet kada galite at\u0161aukti m\u016Bs\u0173 {usageLink}. "
  );
  Labels.set(
    "ui-cookie-consent",
    "disclaimer",
    "Kai kurie slapukai yra b\u016Btini \u0161ios svetain\u0117s veikimui ir j\u0173 naudojimas grind\u017Eiamas  m\u016Bs\u0173 teis\u0117tu interesu, tod\u0117l J\u016Bs\u0173 sutikimo nepra\u0161oma. \u0160ioje svetain\u0117je naudojami tre\u010Di\u0173j\u0173 \u0161ali\u0173 slapukai."
  );
  Labels.set("ui-cookie-consent", "accept", "Sutinku");
  Labels.set("ui-cookie-consent", "decline", "Nesutinku");
  Labels.set("ui-cookie-consent", "saveChoice", "I\u0161saugoti pasirinkim\u0105");
  Labels.set("ui-cookie-consent", "myCookies", "Pasirinkti savo slapukus");
  Labels.set(
    "ui-cookie-consent",
    "policyLinkLabel",
    "\u201ESwedbank\u201C slapuk\u0173 politikoje"
  );
  Labels.set("ui-cookie-consent", {
    HELP_NECESSARY: "Yra b\u016Btini tam, kad svetain\u0117 veikt\u0173 ir negali b\u016Bti i\u0161jungti, tod\u0117l jiems nepra\u0161omas sutikimas.",
    HELP_ANALYTICAL: "Padeda tobulinti svetain\u0117s veikim\u0105, nes suteikia galimyb\u0119 fiksuoti apsilankym\u0173 skai\u010Di\u0173 bei lankytoj\u0173 srauto \u0161altinius. Nesutikus leisti \u012Fra\u0161yti \u0161i\u0173 slapuk\u0173, J\u016Bs\u0173 apsilankymas svetain\u0117je nepateks \u012F jos statistik\u0105.",
    HELP_TARGETING: "Padeda \u0161ioje svetain\u0117je pateikti Jums pritaikyt\u0105  informacij\u0105 apie paslaugas, pagerinti turinio atrank\u0105, tobulinti svetain\u0117s funkcijas. Gali b\u016Bti naudojami rinkodaros tikslu. Nesutikus priimti \u0161i\u0173 slapuk\u0173, nebus rodomas Jums pritaikytas turinys."
  });
  Labels.set("ui-cookie-consent", {
    CATEGORY_NECESSARY: "B\u016Btinieji",
    CATEGORY_ANALYTICAL: "Analitiniai",
    CATEGORY_TARGETING: "Rinkodaros"
  });
  Labels.set("ui-cookie-consent", "EE", "Estija");
  Labels.set("ui-cookie-consent", "LV", "Latvija");
  Labels.set("ui-cookie-consent", "LT", "Lietuvoje");
  Labels.set("ui-cookie-consent", "entities", "\u012Fmon\u0117s");
  Labels.set("ui-cookie-consent", "cookies", "slapukus");
  Labels.set("ui-cookie-consent", "language", "Kalba");
  Labels.set("ui-cookie-consent", "usage", "slapuk\u0173 naudojimo puslapyje");

  // src/shared-components-labels/ui-countdown/ui-countdown.lt.js
  Labels.set("ui-countdown", "days", "Dienos");
  Labels.set("ui-countdown", "hours", "Valand\u0173");
  Labels.set("ui-countdown", "minutes", "Minu\u010Di\u0173");
  Labels.set("ui-countdown", "seconds", "Sekund\u017Ei\u0173");

  // src/shared-components-labels/ui-curtain/ui-curtain.lt.js
  Labels.set("ui-curtain", "showLess", "Rodyti ma\u017Eiau");
  Labels.set("ui-curtain", "showMore", "Rodyti daugiau");

  // src/shared-components-labels/ui-datepicker/ui-datepicker.lt.js
  Labels.set("ui-datepicker", "chooseDate", "Pasirinkite dat\u0105");
  Labels.set("ui-datepicker", "selectedDate", "Pasirinkta dat\u0105");
  Labels.set("ui-datepicker", "close", "U\u017Edaryti");
  Labels.set("ui-datepicker", "clear", "I\u0161valyti \u012Fvest\u012F");

  // src/shared-components-labels/ui-daterange/ui-daterange.lt.js
  Labels.set("ui-daterange", "TODAY", "\u0160iandien");
  Labels.set("ui-daterange", "YESTERDAY", "Vakar");
  Labels.set("ui-daterange", "CURRENT_WEEK", "\u0160i savait\u0117");
  Labels.set("ui-daterange", "CURRENT_MONTH", "\u0160is m\u0117nuo");
  Labels.set("ui-daterange", "CURRENT_YEAR", "Nuo met\u0173 prad\u017Eios");
  Labels.set("ui-daterange", "PREV_YEAR", "Pra\u0117j\u0119 metai");
  Labels.set("ui-daterange", "PREV_WEEK", "Pra\u0117jusi savait\u0117");
  Labels.set("ui-daterange", "PREV_MONTH", "Pra\u0117j\u0119s m\u0117nuo");
  Labels.set(
    "ui-daterange",
    "PREV_MONTH_TODAY",
    "Pra\u0117j\u0119s m\u0117nuo ir einamasis m\u0117nuo"
  );
  Labels.set("ui-daterange", "PERIOD_START", "Laikotarpio prad\u017Eia");
  Labels.set("ui-daterange", "PERIOD_END", "Laikotarpio pabaiga");
  Labels.set("ui-daterange", "TIME_START", "Laiko prad\u017Eia");
  Labels.set("ui-daterange", "TIME_END", "Laiko pabaiga");

  // src/shared-components-labels/ui-dialog/ui-dialog.lt.js
  Labels.set("ui-dialog", "accept", "Taip");
  Labels.set("ui-dialog", "decline", "Ne");
  Labels.set("ui-dialog", "dismiss", "Gerai");
  Labels.set("ui-dialog", "close", "U\u017Edaryti dialogo lang\u0105");

  // src/shared-components-labels/ui-dialogbubble/ui-dialogbubble.lt.js
  Labels.set("ui-dialogbubble", "open", "Prad\u0117ti pokalb\u012F");

  // src/shared-components-labels/ui-dropdown/ui-dropdown.lt.js
  Labels.set("ui-dropdown", "close", "U\u017Edaryti");

  // src/shared-components-labels/ui-feedback/ui-feedback.lt.js
  Labels.set("ui-feedback", "MIN_RATE", "Buvo sud\u0117tinga");
  Labels.set("ui-feedback", "MAX_RATE", "Buvo lengva");
  Labels.set("ui-feedback", "POSITIVE", "Taip");
  Labels.set("ui-feedback", "NEGATIVE", "Ne");
  Labels.set("ui-feedback", "CONFIRM", "Si\u0173sti");
  Labels.set(
    "ui-feedback",
    "TEXTAREA_LABEL",
    "Pasidalinkite, k\u0105 gal\u0117tume patobulinti, kad ateityje J\u016Bs\u0173 vertinimas b\u016Bt\u0173 geresnis?"
  );
  Labels.set(
    "ui-feedback",
    "HINT_MESSAGE",
    "J\u016Bs\u0173 atsiliepimas yra anoniminis. Jis mums pad\u0117s tobulinti paslaug\u0173 teikim\u0105."
  );
  Labels.set("ui-feedback", "SUCCESS_MESSAGE", "D\u0117kojame u\u017E J\u016Bs\u0173 atsiliepim\u0105!");
  Labels.set("ui-feedback", "ERROR_MESSAGE", "Feedback sending failed");

  // src/shared-components-labels/ui-form/ui-form.lt.js
  Labels.set("validation", "input", "\u012Eveskite teising\u0105 reik\u0161m\u0119.");
  Labels.set("validation", "date", "\u012Eveskite teising\u0105 reik\u0161m\u0119.");
  Labels.set("validation", "time", "\u012Eveskite laik\u0105.");
  Labels.set("validation", "range", "Neteisingai \u012Fvesta reik\u0161m\u0117.");
  Labels.set("validation", "month", "\u012Eveskite teising\u0105 m\u0117nes\u012F.");
  Labels.set("validation", "datetime-local", "\u012Eveskite dat\u0105 ir laik\u0105.");
  Labels.set("validation", "custom", "Patvirtinimo klaida..");
  Labels.set("validation", "pattern", "\u012Eveskite reik\u0161m\u0119 teisingu formatu.");
  Labels.set(
    "validation",
    "rangeOverflow",
    "Reik\u0161m\u0117 turi b\u016Bti ma\u017Eesn\u0117 arba lygi %s."
  );
  Labels.set(
    "validation",
    "rangeUnderflow",
    "Reik\u0161m\u0117 turi b\u016Bti didesn\u0117 arba lygi %s."
  );
  Labels.set(
    "validation",
    "step",
    "\u017Dingsnis turi b\u016Bti %s, artimiausia reik\u0161m\u0117 yra %s ir %s."
  );
  Labels.set(
    "validation",
    "long",
    "Reik\u0161m\u0117 per ilga, maksimalus ilgis yra %s simboliai (-i\u0173)."
  );
  Labels.set(
    "validation",
    "short",
    "Reik\u0161m\u0117 per trumpa, minimalus ilgis yra %s simboliai (-i\u0173)."
  );
  Labels.set("validation", "type", "\u012Eveskite teising\u0105 reik\u0161m\u0119.");
  Labels.set("validation", "email", "\u012Eveskite el. pa\u0161to adres\u0105.");
  Labels.set("validation", "url", "\u012Eveskite puslapio nuorod\u0105.");
  Labels.set("validation", "value", "U\u017Epildykite lauk\u0105.");
  Labels.set("validation", "matches", "Lauk\u0173 reik\u0161m\u0117s nesutampa.");
  Labels.set("validation", "checkboxes", "Pra\u0161ome pasirinkti bent %s variant\u0105.");
  Labels.set("validation", "remote", "Serverio klaida.");
  Labels.set("validation", "maxfilesize", "File(s) size limit exceeded %s Kb.");
  Labels.set(
    "validation",
    "requiredMultiple",
    "Pra\u0161ome pasirinkti bent %s variant\u0105"
  );

  // src/shared-components-labels/ui-message/ui-message.lt.js
  Labels.set("ui-message", "close", "U\u017Edaryti");

  // src/shared-components-labels/ui-modal/ui-modal.lt.js
  Labels.set("ui-modal", "accept", "Taip");
  Labels.set("ui-modal", "decline", "Ne");
  Labels.set("ui-modal", "dismiss", "Gerai");
  Labels.set("ui-modal", "close", "U\u017Edaryti");

  // src/shared-components-labels/ui-monthpicker/ui-monthpicker.lt.js
  Labels.set("ui-monthpicker", "months", [
    "Sausis",
    "Vasaris",
    "Kovas",
    "Balandis",
    "Gegu\u017E\u0117",
    "Bir\u017Eelis",
    "Liepa",
    "Rugpj\u016Btis",
    "Rugs\u0117jis",
    "Spalis",
    "Lapkritis",
    "Gruodis"
  ]);
  Labels.set("ui-monthpicker", "year", "Metai");
  Labels.set("ui-monthpicker", "month", "M\u0117nuo");

  // src/shared-components-labels/ui-nav/ui-nav.lt.js
  Labels.set(
    "ui-tabs",
    "arrowKeys",
    "Nor\u0117dami nar\u0161yti meniu, naudokite rodykli\u0173 klavi\u0161us."
  );

  // src/shared-components-labels/ui-navitem/ui-navitem.lt.js
  Labels.set("ui-item", "REMOVE_SHORTCUT", "Pa\u0161alinti");

  // src/shared-components-labels/ui-navtoggle/ui-navtoggle.lt.js
  Labels.set("ui-navtoggle", "toggleMenu", "Perjungti meniu");
  Labels.set("ui-navtoggle", "closeMenu", "U\u017Edaryti meniu");

  // src/shared-components-labels/ui-navlist/ui-navlist.lt.js
  Labels.set("ui-navlist", "MY_SHORTCUTS", "Mano nuorodos");
  Labels.set("ui-navlist", "REMOVE_SHORTCUT", "Pa\u0161alinti");
  Labels.set(
    "ui-navlist",
    "ADD_SHORTCUT",
    "\u012Etraukti \u0161\u012F puslap\u012F \u012F nuorod\u0173 s\u0105ra\u0161\u0105"
  );
  Labels.set("ui-navlist", "EDIT_SHORTCUTS", "Tvarkyti mano nuorodas");
  Labels.set("ui-navlist", "FINISH_EDITING", "I\u0161saugoti pakeitimus");
  Labels.set("ui-navlist", "BACK", "Atgal");

  // src/shared-components-labels/ui-offer/ui-offer.lt.js
  Labels.set("ui-offer", "dismissOffer", "Atmesti pasi\u016Blym\u0105");

  // src/shared-components-labels/ui-pagination/ui-pagination.lt.js
  Labels.set("ui-pagination", "title", "Puslapi\u0173 nar\u0161ymas");
  Labels.set("ui-pagination", "previousPage", "Ankstesnis puslapis");
  Labels.set("ui-pagination", "nextPage", "Kitas puslapis");
  Labels.set("ui-pagination", "currentPage", "Dabartinis puslapis");
  Labels.set("ui-pagination", "page", "Puslapis");
  Labels.set("ui-pagination", "show", "Rodyti kiekviename puslapyje");

  // src/shared-components-labels/ui-phonefield/ui-phonefield.lt.js
  Labels.set("ui-phonefield", "INVALID", "Blogas telefono numerio formatas.");
  Labels.set("ui-phonefield", "CHOOSE_COUNTRY", "Pasirinkite \u0161al\u012F");
  Labels.set("ui-phonefield", "PHONENR", "Telefono numeris");

  // src/shared-components-labels/ui-rating/ui-rating.lt.js
  Labels.set(
    "ui-rating",
    "navigateArrow",
    "Naudokite rodykli\u0173 klavi\u0161us, kad \u012Fvertintum\u0117te."
  );

  // src/shared-components-labels/ui-searchinput/ui-searchinput.lt.js
  Labels.set("ui-searchinput", "clear", "I\u0161valyti \u012Fvest\u012F");

  // src/shared-components-labels/ui-signing/ui-signing.lt.js
  Labels.set("ui-signing", "TITLE", "Skaitmeninis pasira\u0161ymas");
  Labels.set("ui-signing", "DIGIPASS_CHALLENGE", "Kodas \u012Fvedimui \u012F generatori\u0173:");
  Labels.set(
    "ui-signing",
    "DIGIPASS_PASSWORD",
    "Slapta\u017Eodis i\u0161 kod\u0173 generatoriaus:"
  );
  Labels.set("ui-signing", "DIGIPASS_PLACEHOLDER", "APPLI 2");
  Labels.set("ui-signing", "DIGIPASS_CONFIRM", "Patvirtinti");
  Labels.set(
    "ui-signing",
    "DIGIPASS_ERROR_MESSAGE",
    "Nepavyko pasira\u0161yti su PIN kod\u0173 generatoriumi."
  );
  Labels.set(
    "ui-signing",
    "SMART_ID_RUNNING",
    "U\u017Eklausa i\u0161si\u0173st\u0105 \u012F j\u016Bs\u0173 Smart-ID i\u0161mani\u0105j\u0105 program\u0117l\u0119. Patikrinkite kod\u0105."
  );
  Labels.set("ui-signing", "SMART_ID_CHALLENGE", "J\u016Bs\u0173 kontrolinis kodas:");
  Labels.set(
    "ui-signing",
    "SMART_ID_INTRO_MESSAGE",
    "\u012Esitikinkite, kad sutinkate su pasira\u0161oma informacija. Per\u017Ei\u016Br\u0117ti pasira\u0161om\u0105 dokument\u0105 galite gr\u012F\u017E\u0119 \u012F ankstesn\u012F lang\u0105."
  );
  Labels.set("ui-signing", "SMART_ID_EXPLANATION", "");
  Labels.set(
    "ui-signing",
    "SMART_ID_SENDING_MESSAGE",
    "U\u017Eklausa i\u0161si\u0173sta \u012F j\u016Bs\u0173 i\u0161man\u0173j\u012F \u012Frengin\u012F. Patikrinkite kontrolin\u012F kod\u0105 ir \u012Fveskite PIN2."
  );
  Labels.set(
    "ui-signing",
    "MOBILE_ID_RUNNING",
    "Patvirtinkite su Mobile-ID. B\u016Btinai palyginkite rodom\u0105 kod\u0105!"
  );
  Labels.set("ui-signing", "MOBILE_ID_CHALLENGE", "J\u016Bs\u0173 kontrolinis kodas:");
  Labels.set(
    "ui-signing",
    "MOBILE_ID_INTRO_MESSAGE",
    "\u012Esitikinkite, kad sutinkate su pasira\u0161oma informacija. Per\u017Ei\u016Br\u0117ti pasira\u0161om\u0105 dokument\u0105 galite gr\u012F\u017E\u0119 \u012F ankstesn\u012F lang\u0105."
  );
  Labels.set("ui-signing", "MOBILE_ID_EXPLANATION", "");
  Labels.set(
    "ui-signing",
    "MOBILE_ID_SENDING_MESSAGE",
    "U\u017Eklausa i\u0161si\u0173sta \u012F j\u016Bs\u0173 i\u0161man\u0173j\u012F \u012Frengin\u012F. Patikrinkite kontrolin\u012F kod\u0105 ir \u012Fveskite PIN2."
  );
  Labels.set(
    "ui-signing",
    "EPARAKSTS_MOBILE_RUNNING",
    "U\u017Eklausa i\u0161si\u0173st\u0105 \u012F j\u016Bs\u0173 eParaksts mobile i\u0161mani\u0105j\u0105 program\u0117l\u0119. Patikrinkite kod\u0105."
  );
  Labels.set(
    "ui-signing",
    "EPARAKSTS_MOBILE_CHALLENGE",
    "J\u016Bs\u0173 kontrolinis kodas:"
  );
  Labels.set(
    "ui-signing",
    "EPARAKSTS_MOBILE_INTRO_MESSAGE",
    "\u012Esitikinkite, kad sutinkate su pasira\u0161oma informacija. Per\u017Ei\u016Br\u0117ti pasira\u0161om\u0105 dokument\u0105 galite gr\u012F\u017E\u0119 \u012F ankstesn\u012F lang\u0105."
  );
  Labels.set("ui-signing", "EPARAKSTS_MOBILE_EXPLANATION", "");
  Labels.set(
    "ui-signing",
    "EPARAKSTS_MOBILE_SENDING_MESSAGE",
    "U\u017Eklausa i\u0161si\u0173sta \u012F j\u016Bs\u0173 i\u0161man\u0173j\u012F \u012Frengin\u012F. Patikrinkite kontrolin\u012F kod\u0105 ir \u012Fveskite PIN2."
  );
  Labels.set(
    "ui-signing",
    "EPARAKSTS_MOBILE_ERROR_MESSAGE",
    "Nepavyko pasira\u0161yti su eParaksts mobile."
  );
  Labels.set(
    "ui-signing",
    "SIMPLE_ID_RUNNING",
    "Patvirtinkite biometriniais duomenimis arba PIN kodu. B\u016Btinai palyginkite rodom\u0105 kod\u0105!"
  );
  Labels.set("ui-signing", "SIMPLE_ID_CHALLENGE", "J\u016Bs\u0173 kontrolinis kodas:");
  Labels.set(
    "ui-signing",
    "SIMPLE_ID_INTRO_MESSAGE",
    "\u012Esitikinkite, kad suinkate su pasira\u0161oma informacija. Per\u017Ei\u016Br\u0117ti pasira\u0161om\u0105 dokument\u0105 galite gr\u012F\u017E\u0119 \u012F ankstesn\u012F lang\u0105."
  );
  Labels.set("ui-signing", "SIMPLE_ID_EXPLANATION", "");
  Labels.set(
    "ui-signing",
    "SIMPLE_ID_SENDING_MESSAGE",
    "U\u017Eklausa i\u0161si\u0173sta \u012F j\u016Bs\u0173 i\u0161man\u0173j\u012F \u012Frengin\u012F. Patikrinkite kontrolin\u012F kod\u0105 ir nuskenuokite savo biometrinius duomenis arba \u012Fveskite PIN kod\u0105."
  );
  Labels.set("ui-signing", "CANCEL_BUTTON_LABEL", "Atgal");
  Labels.set("ui-signing", "CONFIRM_BUTTON_LABEL", "Patvirtinti");
  Labels.set(
    "ui-signing",
    "SMART_ID_ERROR_MESSAGE",
    "Nepavyko pasira\u0161yti su Smart-ID."
  );
  Labels.set(
    "ui-signing",
    "MOBILE_ID_ERROR_MESSAGE",
    "Nepavyko pasira\u0161yti su Mobile-ID."
  );
  Labels.set(
    "ui-signing",
    "SIMPLE_ID_ERROR_MESSAGE",
    "Nepavyko pasira\u0161yti biometriniu b\u016Bdu arba PIN kodu."
  );
  Labels.set(
    "ui-signing",
    "CERTIFICATE_ERROR_MESSAGE",
    "Nepavyko pasira\u0161yti su ID kortele."
  );
  Labels.set(
    "ui-signing",
    "SMART_ID_BUTTON_LABEL",
    "Pasira\u0161yti Smart-ID PIN2 kodu"
  );
  Labels.set(
    "ui-signing",
    "MOBILE_ID_BUTTON_LABEL",
    "Pasira\u0161yti Mobile-ID PIN2 kodu"
  );
  Labels.set(
    "ui-signing",
    "EPARAKSTS_MOBILE_BUTTON_LABEL",
    "Pasira\u0161yti eParaksts mobile PIN2 kodu."
  );
  Labels.set(
    "ui-signing",
    "SIMPLE_ID_BUTTON_LABEL",
    "Patvirtinti biometriniais duomenimis arba PIN kodu"
  );
  Labels.set(
    "ui-signing",
    "CERTIFICATE_BUTTON_LABEL",
    "Pasira\u0161yti ID kortel\u0117s PIN2 kodu"
  );
  Labels.set("ui-signing", "DIGIPASS_BUTTON_LABEL", "Patvirtinti");
  Labels.set(
    "ui-signing",
    "HWCRYPTO_DEFAULT_ERROR",
    "Neveikia ID kortel\u0117s pl\u0117tinys. Perkraukite nar\u0161ykl\u0119 ir bandykite i\u0161 naujo. {{info-link}}"
  );
  Labels.set(
    "ui-signing",
    "HWCRYPTO_NO_CERTIFICATES",
    "N\u0117ra galiojan\u010Dio ID kortel\u0117s sertifikato. I\u0161imkite kortel\u0119 i\u0161 skaitytuvo, \u012Fd\u0117kite v\u0117l ir bandykite dar kart\u0105. {{info-link}}"
  );
  Labels.set(
    "ui-signing",
    "HWCRYPTO_USER_CANCEL",
    "Patvirtinimas buvo nutrauktas, nes nuspaud\u0117te mygtuk\u0105 \u201EAt\u0161aukti\u201C."
  );
  Labels.set(
    "ui-signing",
    "HWCRYPTO_DRIVER_ERROR",
    "\u012Evyko ID kortel\u0117s programin\u0117s \u012Frangos klaida. Patikrinkite, ar ID kortel\u0117s nuskaitymo programa atnaujinta. Jei ne - atnaujinkite j\u0105, perkraukite nar\u0161ykl\u0119 ir bandykite dar kart\u0105. {{info-link}}"
  );
  Labels.set(
    "ui-signing",
    "HWCRYPTO_NO_IMPLEMENTATION",
    'Patikrinkite, ar ID kortel\u0117s nuskaitymo programa atnaujinta. \u012Evyko ID kortel\u0117s pl\u0117tinio klaida. Savo nar\u0161ykl\u0117je aktyvuokite \u012Fskiep\u012F \u201EWeb eID" arba \u201EeParaksts signing extension" tada perkraukite nar\u0161ykl\u0119 ir bandykite i\u0161 naujo.'
  );
  Labels.set("ui-signing", "LINK_PLACEHOLDER", "Pla\u010Diau apie ID kortel\u0119");

  // src/shared-components-labels/ui-slider/ui-slider.lt.js
  Labels.set("ui-slider", {
    month: {
      0: "m\u0117nesi\u0173",
      1: "m\u0117nuo",
      2: "m\u0117nesiai"
    },
    year: {
      0: "met\u0173",
      1: "metai",
      2: "metai"
    },
    value: "Vert\u0117"
  });

  // src/shared-components-labels/ui-slides/ui-slides.lt.js
  Labels.set("ui-slides", "titleNav", "Skaidri\u0173 nar\u0161ymas");
  Labels.set("ui-slides", "prev", "Kitas");
  Labels.set("ui-slides", "next", "Ankstesnis");
  Labels.set("ui-slides", "slide", "Skaidr\u0117");

  // src/shared-components-labels/ui-stepper/ui-stepper.lt.js
  Labels.set("ui-stepper", {
    month: {
      0: "m\u0117nesi\u0173",
      1: "m\u0117nuo",
      2: "m\u0117nesiai"
    },
    year: {
      0: "met\u0173",
      1: "metai",
      2: "metai"
    },
    increase: "Padidinti",
    decrease: "Suma\u017Einti",
    value: "Vert\u0117"
  });

  // src/shared-components-labels/ui-tabs/ui-tabs.lt.js
  Labels.set(
    "ui-tabs",
    "arrowKeys",
    "Rodykli\u0173 klavi\u0161ais galima nar\u0161yti tarp skirtuk\u0173"
  );
  Labels.set("ui-tabs", "selectTab", "Pasirinkite skirtuk\u0105");

  // src/shared-components-labels/ui-timerange/ui-timerange.lt.js
  Labels.set("ui-daterange", "TIME_START", "Laiko prad\u017Eia");
  Labels.set("ui-daterange", "TIME_END", "Laiko pabaiga");

  // src/shared-components-labels/ui-table-cloneable/ui-table-cloneable.lt.js
  Labels.set("ui-table-cloneable", "addRow", "Prid\u0117ti eilut\u0119");
  Labels.set("ui-table-cloneable", "removeRow", "I\u0161trinti eilut\u0119");

  // src/shared-components-labels/ui-table-expandable/ui-table-expandable.lt.js
  Labels.set("ui-table-expandable", "expandRow", "I\u0161skleisti eilut\u0119");
  Labels.set("ui-table-expandable", "collapseRow", "Sutraukti eilut\u0119");

  // src/shared-components-labels/ui-table-sortable/ui-table-sortable.lt.js
  Labels.set("ui-table-sortable", "sortBy", "R\u016B\u0161iuoti");

  // src/shared-components-labels/ui-textcounter/ui-textcounter.lt.js
  Labels.set("ui-textcounter", "remaining", "Liko simboli\u0173:");
  Labels.set(
    "ui-textcounter",
    "invalid",
    "Tekstas per ilgas (nedaugiau %d simboli\u0173)."
  );

  // src/shared-components-labels/ui-upload/ui-upload.lt.js
  Labels.set("ui-upload", "upload", "\u012Ekelti");
  Labels.set("ui-upload", "clear", "Pa\u0161alinti fail\u0105");

  // src/shared-components-labels/ui-upload-item/ui-upload-item.lt.js
  Labels.set("ui-upload-item", "remove", "Pa\u0161alinti");

  // src/shared-components-labels/ui-video/ui-video.lt.js
  Labels.set("ui-video", "play", "\u017Di\u016Br\u0117ti video");

  // src/shared-components-labels/ui-wizard/ui-wizard.lt.js
  Labels.set("ui-wizard", "next", "Kitas");
  Labels.set("ui-wizard", "back", "Atgal");

  // src/shared-components-labels/bundles/shared-components.lt.js
  Labels.LANGUAGE = "lt";
  window.UI = { ...window.UI, Labels };
})();
//# sourceMappingURL=shared-components.lt.js.map
